/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.tree.TreeUtils;
import org.sonar.iac.docker.tree.api.DockerImageTree;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.FileTree;
import org.sonar.iac.docker.tree.api.UserTree;

@Rule(key="S6471")
public class PrivilegedUserCheck
implements IacCheck {
    private static final Set<String> UNSAFE_IMAGES = Set.of("aerospike", "almalinux", "alpine", "alt", "amazoncorretto", "amazonlinux", "arangodb", "archlinux", "backdrop", "bash", "buildpack-deps", "busybox", "caddy", "cirros", "clearlinux", "clefos", "clojure", "composer", "consul", "couchdb", "crate", "dart", "debian", "drupal", "eclipse-temurin", "elixir", "erlang", "express-gateway", "fedora", "friendica", "gazebo", "gcc", "golang", "haskell", "haxe", "hitch", "httpd", "hylang", "ibmjava", "influxdb", "joomla", "jruby", "julia", "kapacitor", "mageia", "matomo", "maven", "mediawiki", "monica", "mono", "nats", "nats-streaming", "neurodebian", "nextcloud", "nginx", "notary", "openjdk", "oraclelinux", "orientdb", "perl", "photon", "php", "phpmyadmin", "php-zendserver", "plone", "postfixadmin", "pypy", "python", "redmine", "registry", "rethinkdb", "rockylinux", "ros", "ruby", "rust", "r-base", "sapmachine", "satosa", "silverpeas", "sl", "spiped", "swipl", "telegraf", "tomcat", "tomee", "traefik", "ubuntu", "xwiki", "yourls", "bonita", "cassandra", "centos", "chronograf", "convertigo", "couchbase", "docker", "eclipse-mosquitto", "eggdrop", "ghost", "gradle", "mariadb", "mongo", "mongo-express", "mysql", "node", "postgres", "rabbitmq", "rakudo-star", "redis", "sonarqube", "storm", "swift", "teamspeak", "zookeeper");
    private static final Set<String> UNSAFE_USERS = Set.of("root", "containerAdministrator");
    private static final String SAFE_IMAGES = "adminer, api-firewall, elasticsearch, emqx, flink, fluentd, geonetwork, groovy, haproxy, ibm-semeru-runtimes, irssi, jetty, jobber, kibana, kong, lightstreamer, logstash, memcached, neo4j, odoo, open-liberty, percona, rocket.chat, solr, swift, varnish, vault, websphere-liberty, znc, nginxinc/nginx-unprivileged";
    @RuleProperty(key="safeImages", description="Comma separated list of safe images (no default root user).", defaultValue="")
    public String safeImages = "";
    private Set<String> safeImagesSet;
    private static final String MESSAGE_SCRATCH = "Scratch images run as root by default. Make sure it is safe here.";
    private static final String MESSAGE_UNSAFE_DEFAULT_ROOT = "The %s image runs with root as the default user. Make sure it is safe here.";
    private static final String MESSAGE_MICROSOFT_DEFAULT_ROOT = "This image runs with root or containerAdministrator as the default user. Make sure it is safe here.";
    private static final String MESSAGE_OTHER_IMAGE = "This image might run with root as the default user. Make sure it is safe here.";
    private static final String MESSAGE_ROOT_USER = "Setting the default user as %s might unnecessarily make the application unsafe. Make sure it is safe here.";

    private Set<String> userSafeImages() {
        if (this.safeImagesSet == null) {
            this.safeImagesSet = Stream.of(this.safeImages.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        return this.safeImagesSet;
    }

    public void initialize(InitContext init) {
        init.register(DockerImageTree.class, this::handle);
    }

    private void handle(CheckContext ctx, DockerImageTree dockerImage) {
        if (!PrivilegedUserCheck.isLastDockerImageInFile(dockerImage)) {
            return;
        }
        String imageName = dockerImage.from().image().name().value();
        Optional<UserTree> lastUser = PrivilegedUserCheck.getLastUser(dockerImage);
        if (lastUser.isEmpty()) {
            if (PrivilegedUserCheck.isScratchImage(imageName)) {
                ctx.reportIssue((HasTextRange)dockerImage.from(), MESSAGE_SCRATCH);
            } else if (PrivilegedUserCheck.isUnsafeImage(imageName) && !this.isUserSafeImage(imageName)) {
                ctx.reportIssue((HasTextRange)dockerImage.from(), String.format(MESSAGE_UNSAFE_DEFAULT_ROOT, imageName));
            } else if (PrivilegedUserCheck.isMicrosoftUnsafeImage(imageName)) {
                ctx.reportIssue((HasTextRange)dockerImage.from(), MESSAGE_MICROSOFT_DEFAULT_ROOT);
            } else if (!this.isSafeImage(imageName)) {
                ctx.reportIssue((HasTextRange)dockerImage.from(), MESSAGE_OTHER_IMAGE);
            }
        } else {
            String user = lastUser.get().user().value();
            if (UNSAFE_USERS.contains(user)) {
                ctx.reportIssue((HasTextRange)lastUser.get(), String.format(MESSAGE_ROOT_USER, user));
            }
        }
    }

    private static boolean isLastDockerImageInFile(DockerImageTree dockerImage) {
        FileTree parent = (FileTree)dockerImage.parent();
        List<DockerImageTree> dockerImageTrees = parent.dockerImages();
        DockerImageTree last = dockerImageTrees.get(dockerImageTrees.size() - 1);
        return last == dockerImage;
    }

    private static Optional<UserTree> getLastUser(DockerImageTree dockerImage) {
        return TreeUtils.getLastDescendant(dockerImage, tree -> ((DockerTree)tree).is(DockerTree.Kind.USER)).map(UserTree.class::cast);
    }

    private static boolean isScratchImage(String imageName) {
        return imageName.equals("scratch");
    }

    private static boolean isUnsafeImage(String imageName) {
        return UNSAFE_IMAGES.contains(imageName);
    }

    private boolean isSafeImage(String imageName) {
        return SAFE_IMAGES.contains(imageName) || imageName.startsWith("bitnami/") || this.isUserSafeImage(imageName);
    }

    private boolean isUserSafeImage(String imageName) {
        return this.userSafeImages().contains(imageName);
    }

    private static boolean isMicrosoftUnsafeImage(String imageName) {
        return imageName.startsWith("mcr.microsoft.com/");
    }
}

