/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.docker.tree.api.ParamTree;
import org.sonar.iac.docker.tree.api.RunTree;
import org.sonar.iac.docker.tree.api.SyntaxToken;
import org.sonar.iac.docker.utils.CheckUtils;

@Rule(key="S6469")
public class MountWorldPermissionCheck
implements IacCheck {
    private static final String MESSAGE = "Remove world permissions for this sensitive %s.";
    private static final Pattern MOUNT_TYPE_PATTERN = Pattern.compile("type=(secret|ssh)");
    private static final Pattern MOUNT_MODE_PATTERN = Pattern.compile("mode=(\\d+)");
    private static final Map<String, String> DENOMINATION_BY_TYPE = Map.of("secret", "file", "ssh", "agent");

    public void initialize(InitContext init) {
        init.register(RunTree.class, (ctx, run) -> CheckUtils.getParamByName(run.options(), "mount").map(ParamTree::value).ifPresent(mount -> MountWorldPermissionCheck.checkMountParam(ctx, mount)));
    }

    private static void checkMountParam(CheckContext ctx, SyntaxToken mountOptions) {
        String value = mountOptions.value();
        TextPointer start = mountOptions.textRange().start();
        MountOption type = MountOption.creatFromMatcher(MOUNT_TYPE_PATTERN.matcher(value), start);
        MountOption mode = MountOption.creatFromMatcher(MOUNT_MODE_PATTERN.matcher(value), start);
        if (type != null && mode != null && MountWorldPermissionCheck.isModeSensitive(mode.value)) {
            ctx.reportIssue(mode.textRange, String.format(MESSAGE, DENOMINATION_BY_TYPE.get(type.value)));
        }
    }

    private static boolean isModeSensitive(String mode) {
        char lastChar = mode.charAt(mode.length() - 1);
        return lastChar != '0';
    }

    static class MountOption {
        final String value;
        final TextRange textRange;

        private MountOption(String value, TextRange textRange) {
            this.value = value;
            this.textRange = textRange;
        }

        @CheckForNull
        public static MountOption creatFromMatcher(Matcher matcher, TextPointer start) {
            if (matcher.find()) {
                int line = start.line();
                int startColumn = start.lineOffset() + matcher.start();
                int endColum = start.lineOffset() + matcher.end();
                String value = matcher.group(1);
                TextRange range = TextRanges.range((int)line, (int)startColumn, (int)line, (int)endColum);
                return new MountOption(value, range);
            }
            return null;
        }
    }
}

