/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.docker.tree.api.ExposeTree;
import org.sonar.iac.docker.tree.api.PortTree;
import org.sonar.iac.docker.tree.api.SyntaxToken;

@Rule(key="S6473")
public class ExposePortCheck
implements IacCheck {
    private static final Logger LOG = Loggers.get(ExposePortCheck.class);
    private static final String MESSAGE = "Make sure that exposing administration services is safe here.";
    private static final String DEFAULT_SENSITIVE_PORTS = "22, 23, 3389, 5800, 5900";
    private List<Integer> sensitivePorts;
    @RuleProperty(key="ports", description="Comma separated list of sensitive ports.", defaultValue="22, 23, 3389, 5800, 5900")
    String portList = "22, 23, 3389, 5800, 5900";

    public void initialize(InitContext init) {
        init.register(ExposeTree.class, (ctx, instruction) -> instruction.ports().forEach(port -> this.checkPort((CheckContext)ctx, (PortTree)port)));
        this.sensitivePorts = ExposePortCheck.sensitivePorts(this.portList);
    }

    private static List<Integer> sensitivePorts(String ports) {
        try {
            return Arrays.stream(ports.split(",\\s*+")).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            LOG.warn("The port list provided for ExposePortCheck (S6473) is not a comma seperated list of integers. The default list is used. Invalid list of ports \"{}\"", (Object)ports);
            return ExposePortCheck.sensitivePorts(DEFAULT_SENSITIVE_PORTS);
        }
    }

    private void checkPort(CheckContext ctx, PortTree port) {
        if (ExposePortCheck.isTcpProtocol(port.protocol())) {
            try {
                int min = Integer.parseInt(port.portMin().value());
                int max = Integer.parseInt(port.portMax().value());
                if (this.isSensitivePort(min, max)) {
                    ctx.reportIssue((HasTextRange)port, MESSAGE);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean isSensitivePort(int min, int max) {
        return this.sensitivePorts.stream().anyMatch(sensitivePort -> ExposePortCheck.isBetween(sensitivePort, min, max));
    }

    private static boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    private static boolean isTcpProtocol(@Nullable SyntaxToken protocol) {
        if (protocol != null) {
            return "tcp".equals(protocol.value());
        }
        return true;
    }
}

