/*
 * SonarQube IaC Plugin
 * Copyright (C) 2021-2022 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.iac.docker.parser.grammar;

import org.sonar.sslr.grammar.GrammarRuleKey;

public enum DockerKeyword implements GrammarRuleKey {

  ONBUILD("ONBUILD"),
  FROM("FROM"),
  MAINTAINER("MAINTAINER"),
  STOPSIGNAL("STOPSIGNAL"),
  WORKDIR("WORKDIR"),
  EXPOSE("EXPOSE"),
  LABEL("LABEL"),
  AS("AS"),
  ENV("ENV"),
  ARG("ARG"),
  CMD("CMD"),
  ENTRYPOINT("ENTRYPOINT"),
  RUN("RUN"),
  ADD("ADD"),
  COPY("COPY"),
  USER("USER"),
  VOLUME("VOLUME"),
  SHELL("SHELL"),
  HEALTHCHECK("HEALTHCHECK"),
  NONE("NONE")
  ;

  private final String value;

  DockerKeyword(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }
}
