/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.comments.CommentLine;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.Node;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.impl.CommentImpl;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.extension.ParseException;

public final class YamlTreeMetadata
implements HasTextRange {
    private final String tag;
    private final TextRange textRange;
    private final List<Comment> comments;

    public YamlTreeMetadata(String tag, TextRange textRange, List<Comment> comments) {
        this.tag = tag;
        this.textRange = textRange;
        this.comments = comments;
    }

    public String tag() {
        return this.tag;
    }

    @Override
    public TextRange textRange() {
        return this.textRange;
    }

    public List<Comment> comments() {
        return this.comments;
    }

    public static YamlTreeMetadata fromNode(String tag, Node node) {
        return new YamlTreeMetadata(tag, YamlTreeMetadata.range(node), YamlTreeMetadata.comments(node));
    }

    public static YamlTreeMetadata fromNode(Node node) {
        return YamlTreeMetadata.fromNode(YamlTreeMetadata.tag(node), node);
    }

    public static YamlTreeMetadata fromNodes(String tag, Node firstNode, Node secondNode) {
        return new YamlTreeMetadata(tag, TextRanges.merge(List.of(YamlTreeMetadata.range(firstNode), YamlTreeMetadata.range(secondNode))), Collections.emptyList());
    }

    public static List<Comment> comments(Node node) {
        ArrayList<Comment> comments = new ArrayList<Comment>(YamlTreeMetadata.comments(node.getBlockComments()));
        comments.addAll(YamlTreeMetadata.comments(node.getInLineComments()));
        comments.addAll(YamlTreeMetadata.comments(node.getEndComments()));
        return comments;
    }

    private static List<Comment> comments(@Nullable List<CommentLine> commentLines) {
        if (commentLines == null) {
            return Collections.emptyList();
        }
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (CommentLine comment : commentLines) {
            comments.add(YamlTreeMetadata.comment(comment));
        }
        return comments;
    }

    private static Comment comment(CommentLine comment) {
        return new CommentImpl("#" + comment.getValue(), comment.getValue(), YamlTreeMetadata.range(comment.getStartMark(), comment.getEndMark()));
    }

    public static TextRange range(Node node) {
        return YamlTreeMetadata.range(node.getStartMark(), node.getEndMark());
    }

    private static TextRange range(Optional<Mark> startMark, Optional<Mark> endMark) {
        if (startMark.isEmpty()) {
            throw new ParseException("Nodes are expected to have a start mark during conversion", null);
        }
        int startLine = startMark.get().getLine() + 1;
        int startColumn = startMark.get().getColumn();
        return endMark.map(mark -> TextRanges.range(startLine, startColumn, mark.getLine() + 1, mark.getColumn())).orElseGet(() -> TextRanges.range(startLine, startColumn, startLine, startColumn));
    }

    public static String tag(Node node) {
        return node.getTag().getValue();
    }
}

