/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.object;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.yaml.tree.YamlTree;

abstract class YamlObject<T extends YamlObject<?, ?>, K extends YamlTree> {
    public final CheckContext ctx;
    @Nullable
    public final K tree;
    public final String key;
    public final Status status;

    protected YamlObject(CheckContext ctx, @Nullable K tree, String key, Status status) {
        this.ctx = ctx;
        this.tree = tree;
        this.key = key;
        this.status = status;
    }

    @Nullable
    protected abstract HasTextRange toHighlight();

    public T report(String message) {
        Optional.ofNullable(this.toHighlight()).ifPresent(hasTextRange -> this.ctx.reportIssue((HasTextRange)hasTextRange, message));
        return (T)this;
    }

    static enum Status {
        PRESENT,
        ABSENT,
        UNKNOWN;

    }
}

