/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.testing;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.SensorContextTester;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.LogTesterJUnit5;

public abstract class AbstractSensorTest {
    @RegisterExtension
    public LogTesterJUnit5 logTester = new LogTesterJUnit5();
    protected static final FileLinesContextFactory fileLinesContextFactory = (FileLinesContextFactory)Mockito.mock(FileLinesContextFactory.class);
    protected static final NoSonarFilter noSonarFilter = (NoSonarFilter)Mockito.mock(NoSonarFilter.class);
    protected static final Version VERSION_8_9 = Version.create((int)8, (int)9);
    protected static final SonarRuntime SONAR_RUNTIME_8_9 = SonarRuntimeImpl.forSonarQube((Version)VERSION_8_9, (SonarQubeSide)SonarQubeSide.SCANNER, (SonarEdition)SonarEdition.DEVELOPER);
    @TempDir
    protected File baseDir;
    protected SensorContextTester context;

    @BeforeEach
    void setup() {
        FileLinesContext fileLinesContext = (FileLinesContext)Mockito.mock(FileLinesContext.class);
        Mockito.when((Object)fileLinesContextFactory.createFor((InputFile)ArgumentMatchers.any(InputFile.class))).thenReturn((Object)fileLinesContext);
        this.context = SensorContextTester.create((File)this.baseDir);
        MapSettings settings = new MapSettings();
        settings.setProperty(this.getActivationSettingKey(), Boolean.valueOf(true));
        this.context.setSettings(settings);
    }

    protected abstract String getActivationSettingKey();

    protected void analyse(InputFile ... inputFiles) {
        this.analyse(this.sensor(this.checkFactory(new String[0])), inputFiles);
    }

    protected void analyse(Sensor sensor, InputFile ... inputFiles) {
        for (InputFile inputFile : inputFiles) {
            this.context.fileSystem().add(inputFile);
        }
        sensor.execute((SensorContext)this.context);
    }

    protected InputFile inputFile(String relativePath, String content) {
        return new TestInputFileBuilder("moduleKey", relativePath).setModuleBaseDir(this.baseDir.toPath()).setType(InputFile.Type.MAIN).setLanguage(this.fileLanguageKey()).setCharset(StandardCharsets.UTF_8).setContents(content).build();
    }

    protected CheckFactory checkFactory(String ... ruleKeys) {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        for (String ruleKey : ruleKeys) {
            NewActiveRule newRule = new NewActiveRule.Builder().setRuleKey(RuleKey.of((String)this.repositoryKey(), (String)ruleKey)).setName(ruleKey).build();
            builder.addRule(newRule);
        }
        this.context.setActiveRules((ActiveRules)builder.build());
        return new CheckFactory(this.context.activeRules());
    }

    protected abstract Sensor sensor(CheckFactory var1);

    protected abstract String repositoryKey();

    protected abstract Language language();

    protected abstract String fileLanguageKey();
}

