/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.testing;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.SensorContextTester;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.MetricsVisitor;

public abstract class AbstractMetricsTest {
    protected NoSonarFilter noSonarFilter = (NoSonarFilter)Mockito.mock(NoSonarFilter.class);
    protected TreeParser<Tree> parser;
    protected MetricsVisitor visitor;
    protected SensorContextTester sensorContext;
    protected DefaultInputFile inputFile;
    @TempDir
    public File tempFolder;

    @BeforeEach
    void setUp() {
        this.sensorContext = SensorContextTester.create((File)this.tempFolder);
        FileLinesContext fileLinesContext = (FileLinesContext)Mockito.mock(FileLinesContext.class);
        FileLinesContextFactory fileLinesContextFactory = (FileLinesContextFactory)Mockito.mock(FileLinesContextFactory.class);
        Mockito.when((Object)fileLinesContextFactory.createFor((InputFile)ArgumentMatchers.any(InputFile.class))).thenReturn((Object)fileLinesContext);
        this.parser = this.treeParser();
        this.visitor = this.metricsVisitor(fileLinesContextFactory);
    }

    protected abstract TreeParser<Tree> treeParser();

    protected abstract MetricsVisitor metricsVisitor(FileLinesContextFactory var1);

    protected void scan(String code) {
        this.inputFile = new TestInputFileBuilder("moduleKey", new File(this.tempFolder, "file").getName()).setCharset(StandardCharsets.UTF_8).initMetadata(code).build();
        InputFileContext ctx = new InputFileContext((SensorContext)this.sensorContext, (InputFile)this.inputFile);
        this.visitor.scan(ctx, this.parser.parse(code, null));
    }
}

