/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.testing;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.internal.SensorContextTester;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.SyntaxHighlightingVisitor;

public abstract class AbstractHighlightingTest {
    private final SyntaxHighlightingVisitor highlightingVisitor;
    private final TreeParser<Tree> parser;
    private SensorContextTester sensorContext;
    private DefaultInputFile inputFile;
    @TempDir
    public File tempFolder;

    protected AbstractHighlightingTest(SyntaxHighlightingVisitor highlightingVisitor, TreeParser<Tree> parser) {
        this.highlightingVisitor = highlightingVisitor;
        this.parser = parser;
    }

    @BeforeEach
    void setUp() {
        this.sensorContext = SensorContextTester.create((File)this.tempFolder);
    }

    protected void highlight(String code) {
        this.inputFile = new TestInputFileBuilder("moduleKey", this.tempFolder.getName()).setCharset(StandardCharsets.UTF_8).initMetadata(code).build();
        InputFileContext ctx = new InputFileContext((SensorContext)this.sensorContext, (InputFile)this.inputFile);
        this.highlightingVisitor.scan(ctx, this.parser.parse(code, null));
    }

    protected void assertHighlighting(int columnFirst, int columnLast, @Nullable TypeOfText type) {
        this.assertHighlighting(1, columnFirst, columnLast, type);
    }

    protected void assertHighlighting(int line, int columnFirst, int columnLast, @Nullable TypeOfText type) {
        for (int i = columnFirst; i <= columnLast; ++i) {
            List typeOfTexts = this.sensorContext.highlightingTypeAt(this.inputFile.key(), line, i);
            if (type != null) {
                ((ListAssert)Assertions.assertThat((List)typeOfTexts).as("Expect highlighting " + type + " at line " + line + " lineOffset " + i, new Object[0])).containsExactly((Object[])new TypeOfText[]{type});
                continue;
            }
            ((ListAssert)Assertions.assertThat((List)typeOfTexts).as("Expect no highlighting at line " + line + " lineOffset " + i, new Object[0])).containsExactly((Object[])new TypeOfText[0]);
        }
    }
}

