/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;

public class Policy {
    private final Tree version;
    private final Tree id;
    private final List<Statement> statement;

    public <T extends Tree> Policy(T policyDocument, Function<T, List<T>> statementsProvider) {
        this.version = PropertyUtils.valueOrNull(policyDocument, "Version");
        this.id = PropertyUtils.valueOrNull(policyDocument, "Id");
        this.statement = statementsProvider.apply(policyDocument).stream().map(x$0 -> new Statement((Tree)x$0)).collect(Collectors.toList());
    }

    public Optional<Tree> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<Tree> id() {
        return Optional.ofNullable(this.id);
    }

    public List<Statement> statement() {
        return this.statement;
    }

    public static class Statement {
        private final Tree sid;
        private final Tree effect;
        private final Tree principal;
        private final Tree notPrincipal;
        private final Tree action;
        private final Tree notAction;
        private final Tree resource;
        private final Tree notResource;
        private final Tree condition;

        private Statement(Tree statement) {
            this.sid = PropertyUtils.valueOrNull(statement, "Sid");
            this.effect = PropertyUtils.valueOrNull(statement, "Effect");
            this.principal = PropertyUtils.valueOrNull(statement, "Principal");
            this.notPrincipal = PropertyUtils.valueOrNull(statement, "NotPrincipal");
            this.action = PropertyUtils.valueOrNull(statement, "Action");
            this.notAction = PropertyUtils.valueOrNull(statement, "NotAction");
            this.resource = PropertyUtils.valueOrNull(statement, "Resource");
            this.notResource = PropertyUtils.valueOrNull(statement, "NotResource");
            this.condition = PropertyUtils.valueOrNull(statement, "Condition");
        }

        public Optional<Tree> sid() {
            return Optional.ofNullable(this.sid);
        }

        public Optional<Tree> effect() {
            return Optional.ofNullable(this.effect);
        }

        public Optional<Tree> principal() {
            return Optional.ofNullable(this.principal);
        }

        public Optional<Tree> notPrincipal() {
            return Optional.ofNullable(this.notPrincipal);
        }

        public Optional<Tree> action() {
            return Optional.ofNullable(this.action);
        }

        public Optional<Tree> notAction() {
            return Optional.ofNullable(this.notAction);
        }

        public Optional<Tree> resource() {
            return Optional.ofNullable(this.resource);
        }

        public Optional<Tree> notResource() {
            return Optional.ofNullable(this.notResource);
        }

        public Optional<Tree> condition() {
            return Optional.ofNullable(this.condition);
        }
    }
}

