/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.api.tree.impl;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.fs.internal.DefaultTextRange;
import org.sonarsource.analyzer.commons.TokenLocation;

public class TextRanges {
    private static final Supplier<IllegalArgumentException> MERGE_EXCEPTION_SUPPLIER = () -> new IllegalArgumentException("Can't merge 0 ranges");

    private TextRanges() {
    }

    public static TextRange range(int startLine, int startColumn, int endLine, int endColumn) {
        return new DefaultTextRange((TextPointer)new DefaultTextPointer(startLine, startColumn), (TextPointer)new DefaultTextPointer(endLine, endColumn));
    }

    public static TextRange range(int line, int column, String value) {
        TokenLocation location = new TokenLocation(line, column, value);
        DefaultTextPointer startPointer = new DefaultTextPointer(location.startLine(), location.startLineOffset());
        DefaultTextPointer endPointer = new DefaultTextPointer(location.endLine(), location.endLineOffset());
        return new DefaultTextRange((TextPointer)startPointer, (TextPointer)endPointer);
    }

    public static TextRange merge(List<TextRange> ranges) {
        return new DefaultTextRange(ranges.stream().map(TextRange::start).min(Comparator.naturalOrder()).orElseThrow(MERGE_EXCEPTION_SUPPLIER), ranges.stream().map(TextRange::end).max(Comparator.naturalOrder()).orElseThrow(MERGE_EXCEPTION_SUPPLIER));
    }
}

