/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.visitors.TreeContext;

public class TreeVisitor<C extends TreeContext> {
    private final List<ConsumerFilter<C, ?>> consumers = new ArrayList();

    public void scan(C ctx, @Nullable Tree root) {
        if (root != null) {
            ((TreeContext)ctx).before();
            this.before(ctx, root);
            this.visit(ctx, root);
            this.after(ctx, root);
        }
    }

    private void visit(C ctx, @Nullable Tree node) {
        if (node != null) {
            ((TreeContext)ctx).enter(node);
            for (ConsumerFilter<C, ?> consumer : this.consumers) {
                ((ConsumerFilter)consumer).accept(ctx, node);
            }
            node.children().forEach(child -> this.visit(ctx, (Tree)child));
            ((TreeContext)ctx).leave();
        }
    }

    protected void before(C ctx, Tree root) {
    }

    protected void after(C ctx, Tree root) {
    }

    public <T extends Tree> TreeVisitor<C> register(Class<T> cls, BiConsumer<C, T> visitor) {
        this.consumers.add(new ConsumerFilter(cls, visitor));
        return this;
    }

    private static class ConsumerFilter<C extends TreeContext, T extends Tree> {
        private final Class<T> cls;
        private final BiConsumer<C, T> delegate;

        private ConsumerFilter(Class<T> cls, BiConsumer<C, T> delegate) {
            this.cls = cls;
            this.delegate = delegate;
        }

        private void accept(C ctx, Tree node) {
            if (this.cls.isAssignableFrom(node.getClass())) {
                this.delegate.accept(ctx, (Tree)this.cls.cast(node));
            }
        }
    }
}

