/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.HasProperties;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.Trilean;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static Trilean has(@Nullable Tree tree, String key) {
        if (tree instanceof HasProperties) {
            Set elementTrileans = ((HasProperties)((Object)tree)).properties().stream().map(element -> TextUtils.isValue(element.key(), key)).collect(Collectors.toSet());
            if (elementTrileans.contains((Object)Trilean.TRUE)) {
                return Trilean.TRUE;
            }
            if (elementTrileans.contains((Object)Trilean.UNKNOWN)) {
                return Trilean.UNKNOWN;
            }
        }
        return Trilean.FALSE;
    }

    public static Optional<PropertyTree> get(@Nullable Tree tree, String key) {
        return PropertyUtils.get(tree, key::equals);
    }

    private static Optional<PropertyTree> get(@Nullable Tree tree, Predicate<String> keyMatcher) {
        if (!(tree instanceof HasProperties)) {
            return Optional.empty();
        }
        return ((HasProperties)((Object)tree)).properties().stream().filter(attribute -> TextUtils.matchesValue(attribute.key(), keyMatcher).isTrue()).findFirst();
    }

    public static <T extends Tree> Optional<T> get(@Nullable Tree tree, String key, Class<T> clazz) {
        return PropertyUtils.get(tree, key).filter(clazz::isInstance).map(clazz::cast);
    }

    public static Optional<Tree> key(@Nullable Tree tree, String key) {
        return PropertyUtils.get(tree, key).map(PropertyTree::key);
    }

    public static Optional<Tree> value(@Nullable Tree tree, String key) {
        return PropertyUtils.get(tree, key).map(PropertyTree::value);
    }

    public static Optional<Tree> value(@Nullable Tree tree, Predicate<String> keyMatcher) {
        return PropertyUtils.get(tree, keyMatcher).map(PropertyTree::value);
    }

    public static <T extends Tree> Optional<T> value(@Nullable Tree tree, String key, Class<T> clazz) {
        return PropertyUtils.value(tree, key).filter(clazz::isInstance).map(clazz::cast);
    }

    @CheckForNull
    public static Tree valueOrNull(@Nullable Tree tree, String key) {
        return PropertyUtils.valueOrNull(tree, key, Tree.class);
    }

    @CheckForNull
    public static <T extends Tree> T valueOrNull(@Nullable Tree tree, String key, Class<T> clazz) {
        return (T)((Tree)PropertyUtils.value(tree, key, clazz).orElse(null));
    }
}

