/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.api.tree.impl;

import com.sonar.sslr.api.typed.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.iac.common.api.tree.IacToken;
import org.sonar.iac.common.api.tree.SeparatedList;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.Tuple;

public class SeparatedListImpl<T extends Tree, U extends IacToken>
implements SeparatedList<T, U> {
    private final List<T> elements;
    private final List<U> separators;

    public SeparatedListImpl(List<T> elements, List<U> separators) {
        this.elements = elements;
        this.separators = separators;
    }

    @Override
    public List<T> elements() {
        return this.elements;
    }

    @Override
    public List<U> separators() {
        return this.separators.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<Tree> elementsAndSeparators() {
        ArrayList<Tree> result = new ArrayList<Tree>();
        Iterator<T> elementsIterator = this.elements.iterator();
        Iterator<U> separatorIterator = this.separators.iterator();
        while (elementsIterator.hasNext() && separatorIterator.hasNext()) {
            result.add((Tree)elementsIterator.next());
            IacToken separator = (IacToken)separatorIterator.next();
            if (separator == null) continue;
            result.add(separator);
        }
        if (elementsIterator.hasNext()) {
            result.add((Tree)elementsIterator.next());
        }
        return result;
    }

    public static <R extends Tree, S extends IacToken> SeparatedListImpl<R, S> separatedList(R firstElement, Optional<List<Tuple<S, R>>> additionalElements) {
        return SeparatedListImpl.separatedList(firstElement, (List)additionalElements.or(Collections.emptyList()));
    }

    public static <R extends Tree, S extends IacToken> SeparatedListImpl<R, S> separatedList(R firstElement, List<Tuple<S, R>> additionalElements) {
        ArrayList<Tree> elements = new ArrayList<Tree>();
        ArrayList<IacToken> separators = new ArrayList<IacToken>();
        elements.add(firstElement);
        for (Tuple<S, R> elementsWithSeparators : additionalElements) {
            separators.add((IacToken)elementsWithSeparators.first());
            elements.add((Tree)elementsWithSeparators.second());
        }
        return new SeparatedListImpl(elements, separators);
    }

    public static <R extends Tree, S extends IacToken> SeparatedListImpl<R, S> emptySeparatedList() {
        return new SeparatedListImpl(new ArrayList(), new ArrayList());
    }
}

