/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml.visitors;

import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.extension.visitors.MetricsVisitor;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.SequenceTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

public class YamlMetricsVisitor
extends MetricsVisitor {
    public YamlMetricsVisitor(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter) {
        super(fileLinesContextFactory, noSonarFilter);
    }

    @Override
    protected void languageSpecificMetrics() {
        this.register(ScalarTree.class, (ctx, tree) -> {
            for (int i = tree.textRange().start().line(); i <= YamlMetricsVisitor.endLine(tree); ++i) {
                this.linesOfCode().add(i);
            }
        });
        this.register(MappingTree.class, (ctx, tree) -> this.addBraces((HasTextRange)tree));
        this.register(SequenceTree.class, (ctx, tree) -> this.addBraces((HasTextRange)tree));
        this.register(YamlTree.class, (ctx, tree) -> this.addCommentLines(tree.metadata().comments()));
    }

    private void addBraces(HasTextRange tree) {
        this.linesOfCode().add(tree.textRange().start().line());
        this.linesOfCode().add(YamlMetricsVisitor.endLine(tree));
    }

    private static int endLine(HasTextRange tree) {
        int endLine = tree.textRange().end().line();
        return tree.textRange().end().lineOffset() == 0 ? endLine - 1 : endLine;
    }
}

