/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension.visitors;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.iac.common.api.tree.HasComments;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;

public abstract class SyntaxHighlightingVisitor
extends TreeVisitor<InputFileContext> {
    private static final Logger LOG = Loggers.get(SyntaxHighlightingVisitor.class);
    private NewHighlighting newHighlighting;
    private InputFile inputFile;

    protected SyntaxHighlightingVisitor() {
        this.register(Tree.class, (ctx, tree) -> this.highlightComments((Tree)tree));
        this.languageSpecificHighlighting();
    }

    protected abstract void languageSpecificHighlighting();

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.inputFile = ctx.inputFile;
        this.newHighlighting = ctx.sensorContext.newHighlighting().onFile(this.inputFile);
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        this.newHighlighting.save();
    }

    protected void highlight(HasTextRange tree, TypeOfText typeOfText) {
        if (!TextRanges.isValidAndNotEmpty(tree.textRange())) {
            LOG.debug("Tried to highlight a tree with an empty or invalid range. Skipping it.");
            return;
        }
        this.newHighlighting.highlight(this.inputFile.newRange(tree.textRange().start().line(), tree.textRange().start().lineOffset(), tree.textRange().end().line(), tree.textRange().end().lineOffset()), typeOfText);
    }

    private void highlightComments(Tree tree) {
        if (tree instanceof HasComments) {
            ((HasComments)((Object)tree)).comments().forEach(comment -> this.highlight((HasTextRange)comment, TypeOfText.COMMENT));
        }
    }
}

