/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class FileIdentificationPredicate
implements FilePredicate {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Logger LOG = Loggers.get(FileIdentificationPredicate.class);
    private static final Pattern LINE_TERMINATOR = Pattern.compile("[\\n\\r\\u2028\\u2029]");
    private final String fileIdentifier;

    public FileIdentificationPredicate(String fileIdentifier) {
        this.fileIdentifier = fileIdentifier;
    }

    public boolean apply(InputFile inputFile) {
        return this.hasFileIdentifier(inputFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFileIdentifier(InputFile inputFile) {
        if ("".equals(this.fileIdentifier)) {
            return true;
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputFile.inputStream());){
            String[] lines;
            byte[] bytes = bufferedInputStream.readNBytes(8192);
            String text = new String(bytes, inputFile.charset());
            for (String line : lines = LINE_TERMINATOR.split(text)) {
                if (!line.contains(this.fileIdentifier)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.error(String.format("Unable to read file: %s.", inputFile.uri()));
            LOG.error(e.getMessage());
        }
        LOG.debug("File without identifier '{}': {}", (Object)this.fileIdentifier, (Object)inputFile.uri());
        return false;
    }
}

