/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension.visitors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;

public class ChecksVisitor
extends TreeVisitor<InputFileContext> {
    private final DurationStatistics statistics;

    public ChecksVisitor(Checks<IacCheck> checks, DurationStatistics statistics) {
        this.statistics = statistics;
        Collection activeChecks = checks.all();
        for (IacCheck check : activeChecks) {
            RuleKey ruleKey = checks.ruleKey((Object)check);
            Objects.requireNonNull(ruleKey);
            check.initialize(this.context(ruleKey));
        }
    }

    protected InitContext context(RuleKey ruleKey) {
        return new ContextAdapter(ruleKey);
    }

    public class ContextAdapter
    implements InitContext,
    CheckContext {
        public final RuleKey ruleKey;
        private InputFileContext currentCtx;

        public ContextAdapter(RuleKey ruleKey) {
            this.ruleKey = ruleKey;
        }

        @Override
        public <T extends Tree> void register(Class<T> cls, BiConsumer<CheckContext, T> visitor) {
            ChecksVisitor.this.register(cls, ChecksVisitor.this.statistics.time(this.ruleKey.rule(), (ctx, tree) -> {
                this.currentCtx = ctx;
                visitor.accept(this, tree);
            }));
        }

        @Override
        public void reportIssue(TextRange textRange, String message) {
            this.reportIssue(textRange, message, Collections.emptyList());
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message) {
            this.reportIssue(toHighlight.textRange(), message, Collections.emptyList());
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, SecondaryLocation secondaryLocation) {
            this.reportIssue(toHighlight.textRange(), message, Collections.singletonList(secondaryLocation));
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, List<SecondaryLocation> secondaryLocations) {
            this.reportIssue(toHighlight.textRange(), message, secondaryLocations);
        }

        private void reportIssue(@Nullable TextRange textRange, String message, List<SecondaryLocation> secondaryLocations) {
            this.currentCtx.reportIssue(this.ruleKey, textRange, message, secondaryLocations);
        }
    }
}

