/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;

public class ParseException
extends RuntimeException {
    private final transient TextPointer position;
    private final transient String details;

    public static ParseException throwParseException(String action, @Nullable InputFile inputFile, Exception cause, @Nullable TextPointer position) {
        String message = position != null ? String.format("Cannot %s '%s:%s:%s'", action, inputFile, position.line(), position.lineOffset() + 1) : String.format("Cannot %s '%s'", action, inputFile);
        return new ParseException(message, position, cause.getMessage());
    }

    public ParseException(String message, @Nullable TextPointer position, @Nullable String details) {
        super(message);
        this.position = position;
        this.details = details;
    }

    @CheckForNull
    public TextPointer getPosition() {
        return this.position;
    }

    @CheckForNull
    public String getDetails() {
        return this.details;
    }
}

