/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.exceptions.ParserException;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.iac.common.api.tree.impl.TextRanges;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.FileTreeImpl;
import org.sonar.iac.common.yaml.tree.MappingTreeImpl;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.ScalarTreeImpl;
import org.sonar.iac.common.yaml.tree.SequenceTreeImpl;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.TupleTreeImpl;
import org.sonar.iac.common.yaml.tree.YamlTree;
import org.sonar.iac.common.yaml.tree.YamlTreeMetadata;
import org.sonarsource.analyzer.commons.collections.ListUtils;

public class YamlConverter {
    private final Map<Class<?>, Function<Node, YamlTree>> converters = Map.of(MappingNode.class, node -> this.convertMapping((MappingNode)node), ScalarNode.class, node -> this.convertScalar((ScalarNode)node), SequenceNode.class, node -> this.convertSequence((SequenceNode)node));

    public YamlTree convert(Node node) {
        if (node.isRecursive()) {
            throw new ParserException("Recursive node found", node.getStartMark());
        }
        return this.converters.get(node.getClass()).apply(node);
    }

    public FileTree convertFile(List<Node> nodes) {
        if (nodes.isEmpty()) {
            throw new ParseException("Unexpected empty nodes list while converting file", null);
        }
        TextRange fileRange = TextRanges.merge(List.of(YamlTreeMetadata.range(nodes.get(0)), YamlTreeMetadata.range((Node)ListUtils.getLast(nodes))));
        YamlTreeMetadata metadata = new YamlTreeMetadata("FILE", fileRange, Collections.emptyList());
        List<YamlTree> documents = nodes.stream().map(this::convert).collect(Collectors.toList());
        return new FileTreeImpl(documents, metadata);
    }

    protected YamlTree convertMapping(MappingNode mappingNode) {
        ArrayList<TupleTree> elements = new ArrayList<TupleTree>();
        for (NodeTuple elementNode : mappingNode.getValue()) {
            elements.add(this.convertTuple(elementNode));
        }
        return new MappingTreeImpl(elements, YamlTreeMetadata.fromNode((Node)mappingNode));
    }

    protected YamlTree convertScalar(ScalarNode scalarNode) {
        return new ScalarTreeImpl(scalarNode.getValue(), YamlConverter.scalarStyleConvert(scalarNode.getScalarStyle()), YamlTreeMetadata.fromNode((Node)scalarNode));
    }

    protected TupleTree convertTuple(NodeTuple tuple) {
        YamlTree key = this.convert(tuple.getKeyNode());
        YamlTree value = this.convert(tuple.getValueNode());
        return new TupleTreeImpl(key, value, YamlTreeMetadata.fromNodes("TUPLE", tuple.getKeyNode(), tuple.getValueNode()));
    }

    protected YamlTree convertSequence(SequenceNode sequenceNode) {
        ArrayList<YamlTree> elements = new ArrayList<YamlTree>();
        for (Node elementNode : sequenceNode.getValue()) {
            elements.add(this.convert(elementNode));
        }
        return new SequenceTreeImpl(elements, YamlTreeMetadata.fromNode((Node)sequenceNode));
    }

    protected static ScalarTree.Style scalarStyleConvert(ScalarStyle style) {
        switch (style) {
            case DOUBLE_QUOTED: {
                return ScalarTree.Style.DOUBLE_QUOTED;
            }
            case SINGLE_QUOTED: {
                return ScalarTree.Style.SINGLE_QUOTED;
            }
            case LITERAL: {
                return ScalarTree.Style.LITERAL;
            }
            case FOLDED: {
                return ScalarTree.Style.FOLDED;
            }
            case PLAIN: {
                return ScalarTree.Style.PLAIN;
            }
        }
        return ScalarTree.Style.OTHER;
    }
}

