/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.testing;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.HasComments;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonarsource.analyzer.commons.checks.verifier.SingleFileVerifier;

public final class Verifier {
    private Verifier() {
    }

    public static void verify(TreeParser<Tree> parser, Path path, IacCheck check) {
        Verifier.verify(parser, path, check, TestContext::new);
    }

    public static void verify(TreeParser<Tree> parser, Path path, IacCheck check, Function<SingleFileVerifier, TestContext> contextSupplier) {
        Tree root = Verifier.parse(parser, path);
        SingleFileVerifier verifier = Verifier.createVerifier(path, root);
        Verifier.runAnalysis(contextSupplier.apply(verifier), check, root);
        verifier.assertOneOrMoreIssues();
    }

    public static void verify(TreeParser<Tree> parser, Path path, IacCheck check, Issue ... expectedIssues) {
        Tree root = Verifier.parse(parser, path);
        List<Issue> actualIssues = Verifier.runAnalysis(new TestContext(Verifier.createVerifier(path, root)), check, root);
        Verifier.compare(actualIssues, Arrays.asList(expectedIssues));
    }

    public static void verifyNoIssue(TreeParser<Tree> parser, Path path, IacCheck check) {
        Verifier.verifyNoIssue(parser, path, check, TestContext::new);
    }

    public static void verifyNoIssue(TreeParser<Tree> parser, Path path, IacCheck check, Function<SingleFileVerifier, TestContext> contextSupplier) {
        Tree root = Verifier.parse(parser, path);
        SingleFileVerifier verifier = Verifier.createVerifier(path, root);
        List<Issue> actualIssues = Verifier.runAnalysis(contextSupplier.apply(verifier), check, root);
        Verifier.compare(actualIssues, Collections.emptyList());
    }

    private static List<Issue> runAnalysis(TestContext ctx, IacCheck check, Tree root) {
        check.initialize(ctx);
        ctx.scan(root);
        return ctx.raisedIssues;
    }

    private static Tree parse(TreeParser<Tree> parser, Path path) {
        String testFileContent = Verifier.readFile(path);
        return parser.parse(testFileContent, null);
    }

    private static SingleFileVerifier createVerifier(Path path, Tree root) {
        SingleFileVerifier verifier = SingleFileVerifier.create((Path)path, (Charset)StandardCharsets.UTF_8);
        HashMap commentsByLine = new HashMap();
        HashSet alreadyAdded = new HashSet();
        new TreeVisitor<TreeContext>().register(Tree.class, (ctx, tree) -> {
            if (tree instanceof HasComments && !alreadyAdded.contains(tree.textRange())) {
                for (Comment comment : ((HasComments)((Object)tree)).comments()) {
                    commentsByLine.computeIfAbsent(comment.textRange().start().line(), i -> new HashSet()).add(comment);
                }
                alreadyAdded.add(tree.textRange());
            }
        }).scan(new TreeContext(), root);
        commentsByLine.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).forEach(comments -> comments.forEach(comment -> {
            TextPointer start = comment.textRange().start();
            verifier.addComment(start.line(), start.lineOffset() + 1, comment.value(), 2, 0);
        }));
        return verifier;
    }

    private static String readFile(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + path, e);
        }
    }

    private static void compare(List<Issue> actualIssues, List<Issue> expectedIssues) {
        Tuple tuple;
        TextRange range;
        HashMap<TextRange, Tuple> map = new HashMap<TextRange, Tuple>();
        for (Issue issue : actualIssues) {
            range = issue.textRange;
            if (map.get(range) == null) {
                tuple = new Tuple();
                tuple.addActual(issue);
                map.put(range, tuple);
                continue;
            }
            ((Tuple)map.get(range)).addActual(issue);
        }
        for (Issue issue : expectedIssues) {
            range = issue.textRange;
            if (map.get(range) == null) {
                tuple = new Tuple();
                tuple.addExpected(issue);
                map.put(range, tuple);
                continue;
            }
            ((Tuple)map.get(range)).addExpected(issue);
        }
        StringBuilder errorBuilder = new StringBuilder();
        for (Tuple tuple2 : map.values()) {
            errorBuilder.append(tuple2.check());
        }
        String string = errorBuilder.toString();
        if (!string.isEmpty()) {
            throw new AssertionError((Object)("\n\n" + string));
        }
    }

    private static class Tuple {
        private static final String NO_ISSUE = "* [NO_ISSUE] Expected but no issue on range %s.\n\n";
        private static final String WRONG_MESSAGE = "* [WRONG_MESSAGE] Issue at %s : \nExpected message : %s\nActual message : %s\n\n";
        private static final String UNEXPECTED_ISSUE = "* [UNEXPECTED_ISSUE] at %s with a message: \"%s\"\n\n";
        private static final String WRONG_NUMBER = "* [WRONG_NUMBER] Range %s: Expecting %s issue, but actual issues number is %s\n\n";
        private static final String NO_SECONDARY = "* [NO_SECONDARY] Expected but no secondary location for issue at line %d on range %s.\n\n";
        private static final String UNEXPECTED_SECONDARY = "* [UNEXPECTED_SECONDARY] for issue at line %s at %s with a message: \"%s\"\n\n";
        List<Issue> actual = new ArrayList<Issue>();
        List<Issue> expected = new ArrayList<Issue>();

        private Tuple() {
        }

        void addActual(Issue actual) {
            this.actual.add(actual);
        }

        void addExpected(Issue expected) {
            this.expected.add(expected);
        }

        String check() {
            if (!this.actual.isEmpty() && this.expected.isEmpty()) {
                return String.format(UNEXPECTED_ISSUE, this.actual.get((int)0).textRange, this.actual.get((int)0).message);
            }
            if (this.actual.isEmpty() && !this.expected.isEmpty()) {
                return String.format(NO_ISSUE, this.expected.get((int)0).textRange);
            }
            if (this.actual.size() == 1 && this.expected.size() == 1) {
                Issue expectedIssue = this.expected.get(0);
                Issue actualIssue = this.actual.get(0);
                return Tuple.compareIssues(expectedIssue, actualIssue);
            }
            if (this.actual.size() != this.expected.size()) {
                return String.format(WRONG_NUMBER, this.actual.get((int)0).textRange, this.expected.size(), this.actual.size());
            }
            for (int i = 0; i < this.actual.size(); ++i) {
                if (this.actual.get((int)i).message.equals(this.expected.get((int)i).message)) continue;
                return String.format(WRONG_MESSAGE, this.actual.get((int)i).textRange, this.expected.get((int)i).message, this.actual.get((int)i).message);
            }
            return "";
        }

        private static String compareIssues(Issue expectedIssue, Issue actualIssue) {
            String expectedMessage = expectedIssue.message;
            if (expectedMessage != null && !actualIssue.message.equals(expectedMessage)) {
                return String.format(WRONG_MESSAGE, actualIssue.textRange, expectedMessage, actualIssue.message);
            }
            StringBuilder secondaryMessages = new StringBuilder();
            if (!expectedIssue.secondaryLocations.isEmpty()) {
                expectedIssue.secondaryLocations.stream().filter(e -> !actualIssue.secondaryLocations.contains(e)).forEach(second -> secondaryMessages.append(String.format(NO_SECONDARY, expectedIssue.textRange.start().line(), second.textRange)));
                actualIssue.secondaryLocations.stream().filter(e -> !expectedIssue.secondaryLocations.contains(e)).forEach(second -> secondaryMessages.append(String.format(UNEXPECTED_SECONDARY, actualIssue.textRange.start().line(), second.textRange, second.message)));
            }
            return secondaryMessages.toString();
        }
    }

    public static class Issue {
        private final TextRange textRange;
        private final String message;
        private final List<SecondaryLocation> secondaryLocations;

        public Issue(TextRange textRange, @Nullable String message, List<SecondaryLocation> secondaryLocations) {
            this.textRange = textRange;
            this.message = message;
            this.secondaryLocations = secondaryLocations;
        }

        public Issue(TextRange textRange, @Nullable String message, SecondaryLocation secondaryLocation) {
            this(textRange, message, Collections.singletonList(secondaryLocation));
        }

        public Issue(TextRange textRange, @Nullable String message) {
            this(textRange, message, Collections.emptyList());
        }

        public Issue(TextRange textRange) {
            this(textRange, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Issue other = (Issue)o;
            return this.textRange.equals(other.textRange) && Objects.equals(this.message, other.message) && this.secondaryLocations.equals(other.secondaryLocations);
        }

        public int hashCode() {
            return Objects.hash(this.textRange, this.message, this.secondaryLocations);
        }
    }

    public static class TestContext
    extends TreeContext
    implements InitContext,
    CheckContext {
        private final TreeVisitor<TestContext> visitor;
        private final SingleFileVerifier verifier;
        private final List<Issue> raisedIssues = new ArrayList<Issue>();

        public TestContext(SingleFileVerifier verifier) {
            this.verifier = verifier;
            this.visitor = new TreeVisitor();
        }

        public void scan(@Nullable Tree root) {
            this.visitor.scan(this, root);
        }

        @Override
        public <T extends Tree> void register(Class<T> cls, BiConsumer<CheckContext, T> consumer) {
            this.visitor.register(cls, (C ctx, T node) -> consumer.accept(this, node));
        }

        @Override
        public void reportIssue(TextRange textRange, String message) {
            this.reportIssue(textRange, message, Collections.emptyList());
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message) {
            this.reportIssue(toHighlight.textRange(), message, Collections.emptyList());
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, SecondaryLocation secondaryLocations) {
            this.reportIssue(toHighlight.textRange(), message, Collections.singletonList(secondaryLocations));
        }

        @Override
        public void reportIssue(HasTextRange toHighlight, String message, List<SecondaryLocation> secondaryLocations) {
            this.reportIssue(toHighlight.textRange(), message, secondaryLocations);
        }

        private void reportIssue(TextRange textRange, String message, List<SecondaryLocation> secondaryLocations) {
            Issue issue = new Issue(textRange, message, secondaryLocations);
            if (!this.raisedIssues.contains(issue)) {
                TextPointer start = textRange.start();
                TextPointer end = textRange.end();
                SingleFileVerifier.Issue reportedIssue = this.verifier.reportIssue(message).onRange(start.line(), start.lineOffset() + 1, end.line(), end.lineOffset());
                secondaryLocations.forEach(secondary -> reportedIssue.addSecondary(secondary.textRange.start().line(), secondary.textRange.start().lineOffset() + 1, secondary.textRange.end().line(), secondary.textRange.end().lineOffset(), secondary.message));
                this.raisedIssues.add(issue);
            }
        }
    }
}

