/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.testing;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.iac.common.testing.AbstractSensorTest;

public abstract class ExtensionSensorTest
extends AbstractSensorTest {
    protected static final String PARSING_ERROR_RULE_KEY = "S2260";

    protected abstract InputFile emptyFile();

    protected abstract InputFile fileWithParsingError();

    protected abstract InputFile validFile();

    @Test
    void emptyFileShouldRaiseNoIssue() {
        this.analyse(this.sensor(this.checkFactory(PARSING_ERROR_RULE_KEY)), this.emptyFile());
        Assertions.assertThat((Collection)this.context.allIssues()).isEmpty();
        Assertions.assertThat((Collection)this.context.allAnalysisErrors()).isEmpty();
    }

    @Test
    void shouldRaiseIssueOnParsingErrorWhenIssueActive() {
        InputFile inputFile = this.fileWithParsingError();
        this.analyse(this.sensor(this.checkFactory(PARSING_ERROR_RULE_KEY)), inputFile);
        Assertions.assertThat((Collection)this.context.allIssues()).hasSize(1);
        Issue issue = (Issue)this.context.allIssues().iterator().next();
        ((AbstractStringAssert)Assertions.assertThat((String)issue.ruleKey().rule()).as("A parsing error must be raised", new Object[0])).isEqualTo(PARSING_ERROR_RULE_KEY);
        IssueLocation location = issue.primaryLocation();
        Assertions.assertThat((Object)location.inputComponent()).isEqualTo((Object)inputFile);
        Assertions.assertThat((String)location.message()).isEqualTo("A parsing error occurred in this file.");
        TextRange range = issue.primaryLocation().textRange();
        Assertions.assertThat((Object)range).isNotNull();
        Collection analysisErrors = this.context.allAnalysisErrors();
        Assertions.assertThat((Collection)analysisErrors).hasSize(1);
        AnalysisError analysisError = (AnalysisError)analysisErrors.iterator().next();
        Assertions.assertThat((Object)analysisError.inputFile()).isEqualTo((Object)inputFile);
        Assertions.assertThat((String)analysisError.message()).startsWith((CharSequence)"Unable to parse file:");
        Assertions.assertThat((List)this.logTester.logs(LoggerLevel.ERROR)).hasSize(2);
        ((AbstractListAssert)Assertions.assertThat((List)this.logTester.logs(LoggerLevel.ERROR)).extracting(s -> s).anyMatch(s -> s.startsWith(String.format("Unable to parse file: %s.", inputFile.uri())))).anyMatch(s -> s.startsWith(String.format("Cannot parse '%s':", inputFile.filename())));
    }

    @Test
    void shouldRaiseNoIssueOnParsingErrorWhenIssueInactive() {
        this.analyse(this.sensor(this.checkFactory(new String[0])), this.fileWithParsingError());
        Assertions.assertThat((Collection)this.context.allIssues()).isEmpty();
        Assertions.assertThat((Collection)this.context.allAnalysisErrors()).hasSize(1);
    }

    @Test
    void shouldRaiseNoIssueWhenSensorInactive() {
        MapSettings settings = new MapSettings();
        settings.setProperty(this.getActivationSettingKey(), Boolean.valueOf(false));
        this.context.setSettings(settings);
        this.analyse(this.sensor(this.checkFactory(PARSING_ERROR_RULE_KEY)), this.fileWithParsingError());
        Assertions.assertThat((Collection)this.context.allIssues()).isEmpty();
        Assertions.assertThat((Collection)this.context.allAnalysisErrors()).isEmpty();
    }

    @Test
    void shouldRaiseIssueWhenFileCorrupted() throws IOException {
        InputFile inputFile = this.validFile();
        InputFile spyInputFile = (InputFile)Mockito.spy((Object)inputFile);
        Mockito.when((Object)spyInputFile.contents()).thenThrow(IOException.class);
        this.analyse(spyInputFile);
        Collection analysisErrors = this.context.allAnalysisErrors();
        Assertions.assertThat((Collection)analysisErrors).hasSize(1);
        AnalysisError analysisError = (AnalysisError)analysisErrors.iterator().next();
        Assertions.assertThat((Object)analysisError.inputFile()).isEqualTo((Object)spyInputFile);
        Assertions.assertThat((String)analysisError.message()).startsWith((CharSequence)"Unable to parse file:");
        Assertions.assertThat((Comparable)analysisError.location()).isNull();
    }
}

