/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.testing;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.sonar.iac.common.checks.ParsingErrorCheck;

public abstract class AbstractCheckListTest {
    protected abstract List<Class<?>> checks();

    protected abstract File checkClassDir();

    @Test
    void containsParsingErrorCheck() {
        Assertions.assertThat(this.checks()).contains((Object[])new Class[]{ParsingErrorCheck.class});
    }

    @Test
    void count() {
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"Check.java"), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"Abstract"))});
        Collection files = FileUtils.listFiles((File)this.checkClassDir(), (IOFileFilter)filter, (IOFileFilter)FileFilterUtils.trueFileFilter());
        Assertions.assertThat(this.checks()).hasSize(files.size() + 1);
    }

    @Test
    void test() {
        for (Class<?> cls : this.checks()) {
            if (cls == ParsingErrorCheck.class) continue;
            String testName = "/" + cls.getName().replace('.', '/') + "Test.class";
            ((AbstractUrlAssert)Assertions.assertThat((URL)this.getClass().getResource(testName)).overridingErrorMessage("No test for " + cls.getSimpleName(), new Object[0])).isNotNull();
        }
    }
}

