/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.visitors;

import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.api.tree.MappingTree;
import org.sonar.iac.cloudformation.api.tree.ScalarTree;
import org.sonar.iac.cloudformation.api.tree.SequenceTree;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.extension.visitors.MetricsVisitor;

public class CloudformationMetricsVisitor
extends MetricsVisitor {
    public CloudformationMetricsVisitor(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter) {
        super(fileLinesContextFactory, noSonarFilter);
    }

    protected void languageSpecificMetrics() {
        this.register(ScalarTree.class, (ctx, tree) -> {
            for (int i = tree.textRange().start().line(); i <= CloudformationMetricsVisitor.endLine((HasTextRange)tree); ++i) {
                this.linesOfCode().add(i);
            }
        });
        this.register(MappingTree.class, (ctx, tree) -> this.addBraces((HasTextRange)tree));
        this.register(SequenceTree.class, (ctx, tree) -> this.addBraces((HasTextRange)tree));
        this.register(CloudformationTree.class, (ctx, tree) -> this.addCommentLines(tree.comments()));
    }

    private void addBraces(HasTextRange tree) {
        this.linesOfCode().add(tree.textRange().start().line());
        this.linesOfCode().add(CloudformationMetricsVisitor.endLine(tree));
    }

    private static int endLine(HasTextRange tree) {
        int endLine = tree.textRange().end().line();
        return tree.textRange().end().lineOffset() == 0 ? endLine - 1 : endLine;
    }
}

