/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.api.tree.MappingTree;
import org.sonar.iac.cloudformation.api.tree.SequenceTree;
import org.sonar.iac.cloudformation.api.tree.TupleTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;

public class XPathUtils {
    private final List<CloudformationTree> result = new ArrayList<CloudformationTree>();

    private XPathUtils() {
    }

    public static Optional<CloudformationTree> getSingleTree(CloudformationTree root, String expression) {
        List<CloudformationTree> trees = XPathUtils.getTrees(root, expression);
        if (trees.size() == 1) {
            return Optional.of(trees.get(0));
        }
        return Optional.empty();
    }

    public static List<CloudformationTree> getTrees(CloudformationTree root, String expression) {
        if (!expression.startsWith("/")) {
            throw new InvalidXPathExpression("For now all paths have to start with slash");
        }
        XPathUtils utils = new XPathUtils();
        utils.visitTree(root, new StringTokenizer(expression, "/"));
        return utils.result;
    }

    void visitTree(CloudformationTree tree, StringTokenizer tokenizer) {
        if (!tokenizer.hasMoreTokens()) {
            this.result.add(tree);
            return;
        }
        this.visitTree(tree, tokenizer, tokenizer.nextToken());
    }

    void visitTree(CloudformationTree tree, StringTokenizer tokenizer, String token) {
        boolean expectSequence = false;
        if (token.endsWith("[]")) {
            expectSequence = true;
            token = token.substring(0, token.length() - 2);
        }
        if (tree instanceof MappingTree) {
            String finalToken = token;
            Stream<TupleTree> tuples = ((MappingTree)tree).elements().stream().filter(t -> TextUtils.isValue((Tree)t.key(), (String)finalToken).isTrue());
            if (expectSequence) {
                tuples.map(TupleTree::value).filter(SequenceTree.class::isInstance).forEach(t -> {
                    if (!tokenizer.hasMoreTokens()) {
                        this.result.addAll(((SequenceTree)t).elements());
                    } else {
                        String nextToken = tokenizer.nextToken();
                        ((SequenceTree)t).elements().forEach(e -> this.visitTree((CloudformationTree)e, tokenizer, nextToken));
                    }
                });
            } else {
                tuples.forEach(t -> this.visitTree(t.value(), tokenizer));
            }
        }
    }

    static class InvalidXPathExpression
    extends RuntimeException {
        public InvalidXPathExpression(String message) {
            super(message);
        }
    }
}

