/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.TupleTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S4423")
public class WeakSSLProtocolCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Change this configuration to use a stronger protocol.";
    private static final String STRONG_SSL_PROTOCOL = "TLS_1_2";
    private static final String ELASTIC_STRONG_POLICY = "Policy-Min-TLS-1-2-2019-07";
    private static final String MESSAGE_OMITTING_FORMAT = "Omitting %s disables traffic encryption.";
    private static final String SECURITY_POLICY_KEY = "SecurityPolicy";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::ApiGateway::DomainName")) {
            WeakSSLProtocolCheck.checkApiGatewayDomain(ctx, resource);
        } else if (resource.isType("AWS::ApiGatewayV2::DomainName")) {
            WeakSSLProtocolCheck.checkApiGatewayDomainV2(ctx, resource);
        } else if (resource.isType("AWS::Elasticsearch::Domain") || resource.isType("AWS::OpenSearchService::Domain")) {
            WeakSSLProtocolCheck.checkSearchDomain(ctx, resource);
        }
    }

    private static void checkApiGatewayDomainV2(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)"DomainNameConfigurations", TupleTree.class).ifPresentOrElse(policy -> WeakSSLProtocolCheck.checkDomainNameConfiguration(ctx, policy), () -> WeakSSLProtocolCheck.reportResource(ctx, resource, WeakSSLProtocolCheck.omittingMessage("DomainNameConfigurations.SecurityPolicy")));
    }

    private static void checkApiGatewayDomain(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)SECURITY_POLICY_KEY).ifPresentOrElse(policy -> WeakSSLProtocolCheck.checkSecurityPolicy(ctx, policy), () -> WeakSSLProtocolCheck.reportResource(ctx, resource, WeakSSLProtocolCheck.omittingMessage(SECURITY_POLICY_KEY)));
    }

    private static void checkSearchDomain(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)"DomainEndpointOptions", TupleTree.class).ifPresentOrElse(options -> WeakSSLProtocolCheck.checkDomainEndpointOptions(ctx, options), () -> WeakSSLProtocolCheck.reportResource(ctx, resource, WeakSSLProtocolCheck.omittingMessage("DomainEndpointOptions.TLSSecurityPolicy")));
    }

    private static void checkDomainNameConfiguration(CheckContext ctx, TupleTree config) {
        PropertyUtils.value((Tree)config.value(), (String)SECURITY_POLICY_KEY).ifPresentOrElse(policy -> WeakSSLProtocolCheck.checkSecurityPolicy(ctx, policy), () -> ctx.reportIssue((HasTextRange)config.key(), WeakSSLProtocolCheck.omittingMessage(SECURITY_POLICY_KEY)));
    }

    private static void checkSecurityPolicy(CheckContext ctx, Tree policy) {
        if (TextUtils.isValue((Tree)policy, (String)STRONG_SSL_PROTOCOL).isFalse()) {
            ctx.reportIssue((HasTextRange)policy, MESSAGE);
        }
    }

    private static void checkDomainEndpointOptions(CheckContext ctx, TupleTree options) {
        PropertyUtils.value((Tree)options.value(), (String)"TLSSecurityPolicy").ifPresentOrElse(policy -> WeakSSLProtocolCheck.checkElasticPolicy(ctx, policy), () -> ctx.reportIssue((HasTextRange)options.key(), WeakSSLProtocolCheck.omittingMessage("TLSSecurityPolicy")));
    }

    private static void checkElasticPolicy(CheckContext ctx, Tree policy) {
        if (TextUtils.isValue((Tree)policy, (String)ELASTIC_STRONG_POLICY).isFalse()) {
            ctx.reportIssue((HasTextRange)policy, MESSAGE);
        }
    }

    private static String omittingMessage(String missingProperty) {
        return String.format(MESSAGE_OMITTING_FORMAT, missingProperty);
    }
}

