/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6252")
public class UnversionedS3BucketCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure using %s S3 bucket is safe here.";
    private static final String UNVERSIONED_MSG = "unversioned";
    private static final String SUSPENDED_MSG = "suspended versioned";
    private static final String SECONDARY_MSG = "Related bucket";
    private static final String SUSPENDED_VALUE = "Suspended";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (UnversionedS3BucketCheck.isS3Bucket(resource)) {
            this.checkVersioning(ctx, resource);
        }
    }

    protected void checkVersioning(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        CloudformationTree properties = resource.properties();
        Optional versioning = PropertyUtils.value((Tree)properties, (String)"VersioningConfiguration");
        if (versioning.isPresent()) {
            Optional status = PropertyUtils.value((Tree)((Tree)versioning.get()), (String)"Status");
            if (status.isPresent()) {
                TextUtils.getValue((Tree)((Tree)status.get())).filter(SUSPENDED_VALUE::equals).ifPresent(s -> ctx.reportIssue((HasTextRange)status.get(), String.format(MESSAGE, SUSPENDED_MSG), new SecondaryLocation((HasTextRange)resource.type(), SECONDARY_MSG)));
            } else if (properties != null) {
                ctx.reportIssue((HasTextRange)UnversionedS3BucketCheck.versioningKey(properties), String.format(MESSAGE, UNVERSIONED_MSG), new SecondaryLocation((HasTextRange)resource.type(), SECONDARY_MSG));
            }
        } else {
            ctx.reportIssue((HasTextRange)resource.type(), String.format(MESSAGE, UNVERSIONED_MSG));
        }
    }

    private static Tree versioningKey(CloudformationTree properties) {
        return PropertyUtils.key((Tree)properties, (String)"VersioningConfiguration").orElse(properties);
    }
}

