/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.SequenceTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6321")
public class UnrestrictedAdministrationCheck
extends AbstractResourceCheck {
    public static final String MESSAGE = "Restrict IP addresses authorized to access administration services";
    public static final int SSH_PORT = 22;
    public static final int RDP_PORT = 3389;

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::EC2::SecurityGroup")) {
            UnrestrictedAdministrationCheck.checkSecurityGroup(ctx, resource);
        }
    }

    private static void checkSecurityGroup(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)"SecurityGroupIngress", SequenceTree.class).ifPresent(sequenceTree -> sequenceTree.elements().forEach(r -> UnrestrictedAdministrationCheck.checkIngressRule(ctx, r)));
    }

    private static void checkIngressRule(CheckContext ctx, Tree rule) {
        Optional<Tree> defaultRouteCidrTree = UnrestrictedAdministrationCheck.getDefaultRouteCidr(rule);
        if (!defaultRouteCidrTree.isPresent()) {
            return;
        }
        Optional ipProtocol = PropertyUtils.value((Tree)rule, (String)"IpProtocol");
        if (ipProtocol.isPresent() && TextUtils.isValue((Tree)((Tree)ipProtocol.get()), (String)"-1").isTrue()) {
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree.get(), MESSAGE, new SecondaryLocation((HasTextRange)ipProtocol.get(), "Related protocol setting"));
        } else if (ipProtocol.isPresent() && TextUtils.isValue((Tree)((Tree)ipProtocol.get()), (String)"tcp").isTrue()) {
            UnrestrictedAdministrationCheck.checkTcpPorts(ctx, rule, defaultRouteCidrTree.get(), (Tree)ipProtocol.get());
        }
    }

    private static Optional<Tree> getDefaultRouteCidr(Tree rule) {
        Optional<Tree> optCidrIp = PropertyUtils.value((Tree)rule, (String)"CidrIp").filter(c -> TextUtils.isValue((Tree)c, (String)"0.0.0.0/0").isTrue());
        Optional<Tree> optCidrIpv6 = PropertyUtils.value((Tree)rule, (String)"CidrIpv6").filter(c -> TextUtils.isValue((Tree)c, (String)"::/0").isTrue());
        return optCidrIp.isPresent() ? optCidrIp : optCidrIpv6;
    }

    private static void checkTcpPorts(CheckContext ctx, Tree rule, Tree defaultRouteCidrTree, Tree ipProtocol) {
        Optional fromPort = PropertyUtils.value((Tree)rule, (String)"FromPort");
        Optional toPort = PropertyUtils.value((Tree)rule, (String)"ToPort");
        if (fromPort.isPresent() && toPort.isPresent() && UnrestrictedAdministrationCheck.rangeContainsSshOrRdpPorts((Tree)fromPort.get(), (Tree)toPort.get())) {
            ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
            secondaryLocations.add(new SecondaryLocation((HasTextRange)ipProtocol, "Related protocol setting"));
            secondaryLocations.add(new SecondaryLocation((HasTextRange)fromPort.get(), "Port range start"));
            secondaryLocations.add(new SecondaryLocation((HasTextRange)toPort.get(), "Port range end"));
            ctx.reportIssue((HasTextRange)defaultRouteCidrTree, MESSAGE, secondaryLocations);
        }
    }

    private static boolean rangeContainsSshOrRdpPorts(Tree from, Tree to) {
        Optional fromIntValue = TextUtils.getIntValue((Tree)from);
        Optional toIntValue = TextUtils.getIntValue((Tree)to);
        return fromIntValue.isPresent() && toIntValue.isPresent() && (22 >= (Integer)fromIntValue.get() && 22 <= (Integer)toIntValue.get() || 3389 >= (Integer)fromIntValue.get() && 3389 <= (Integer)toIntValue.get());
    }
}

