/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6275")
public class UnencryptedEbsVolumeCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted volumes is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::EC2::Volume")) {
            return;
        }
        Optional property = PropertyUtils.value((Tree)resource.properties(), (String)"Encrypted");
        if (!property.isPresent()) {
            ctx.reportIssue((HasTextRange)resource.type(), MESSAGE);
        } else {
            Tree encryptedValue = (Tree)property.get();
            if (TextUtils.isValueFalse((Tree)encryptedValue)) {
                ctx.reportIssue((HasTextRange)encryptedValue, MESSAGE);
            }
        }
    }
}

