/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.SequenceTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.PolicyUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.Policy;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6304")
public class ResourceAccessPolicyCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting access to all resources is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::KMS::Key")) {
            return;
        }
        PolicyUtils.getPolicies(resource.properties()).forEach(policy -> ResourceAccessPolicyCheck.checkInsecurePolicy(ctx, policy));
    }

    private static void checkInsecurePolicy(CheckContext ctx, Policy policy) {
        PolicyValidator.findInsecureStatements(policy).forEach(statement -> ctx.reportIssue((HasTextRange)statement.resource, MESSAGE, new SecondaryLocation((HasTextRange)statement.effect, SECONDARY_MESSAGE)));
    }

    private static class PolicyValidator {
        private PolicyValidator() {
        }

        static List<InsecureStatement> findInsecureStatements(Policy policy) {
            ArrayList<InsecureStatement> result = new ArrayList<InsecureStatement>();
            for (Policy.Statement statement : policy.statement()) {
                statement.resource().flatMap(PolicyValidator::findInsecureResource).ifPresent(resource -> statement.effect().filter(PolicyValidator::isAllowEffect).ifPresent(effect -> result.add(new InsecureStatement((Tree)resource, (Tree)effect))));
                statement.notResource().flatMap(PolicyValidator::findInsecureResource).ifPresent(notResource -> statement.effect().filter(PolicyValidator::isDenyEffect).ifPresent(effect -> result.add(new InsecureStatement((Tree)notResource, (Tree)effect))));
            }
            return result;
        }

        private static Optional<Tree> findInsecureResource(Tree resource) {
            if (resource instanceof SequenceTree) {
                return ((SequenceTree)resource).elements().stream().filter(PolicyValidator::applyToAnyResource).map(Tree.class::cast).findAny();
            }
            if (PolicyValidator.applyToAnyResource(resource)) {
                return Optional.of(resource);
            }
            return Optional.empty();
        }

        private static boolean applyToAnyResource(Tree resource) {
            return TextUtils.isValue((Tree)resource, (String)"*").isTrue();
        }

        private static boolean isAllowEffect(Tree effect) {
            return TextUtils.isValue((Tree)effect, (String)"Allow").isTrue();
        }

        private static boolean isDenyEffect(Tree effect) {
            return TextUtils.isValue((Tree)effect, (String)"Deny").isTrue();
        }
    }

    private static class InsecureStatement {
        final Tree resource;
        final Tree effect;

        public InsecureStatement(Tree action, Tree effect) {
            this.resource = action;
            this.effect = effect;
        }
    }
}

