/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.api.tree.FileTree;
import org.sonar.iac.cloudformation.api.tree.MappingTree;
import org.sonar.iac.cloudformation.api.tree.ScalarTree;
import org.sonar.iac.cloudformation.api.tree.TupleTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.XPathUtils;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;

@Rule(key="S6294")
public class LogGroupDeclarationCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure missing \"Log Groups\" declaration is intended here.";
    private static final Set<String> RELEVANT_RESOURCE = new HashSet<String>(Arrays.asList("AWS::Lambda::Function", "AWS::Serverless::Function", "AWS::ApiGatewayV2::Api", "AWS::CodeBuild::Project"));

    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> {
            List<AbstractResourceCheck.Resource> resources = AbstractResourceCheck.getFileResources(tree);
            Set referencedResourceIdentifier = resources.stream().filter(resource -> resource.isType("AWS::Logs::LogGroup")).filter(resource -> resource.properties() instanceof MappingTree).map(LogGroupDeclarationCheck::getReferenceIdentifiers).flatMap(Collection::stream).collect(Collectors.toSet());
            resources.stream().filter(LogGroupDeclarationCheck::isRelevantResource).filter(r -> !LogGroupDeclarationCheck.matchResourceIdentifier(referencedResourceIdentifier, r)).forEach(resource -> ctx.reportIssue((HasTextRange)resource.type(), MESSAGE));
        });
    }

    private static Set<String> getReferenceIdentifiers(AbstractResourceCheck.Resource logGroupResource) {
        return PropertyUtils.value((Tree)logGroupResource.properties(), (String)"LogGroupName", CloudformationTree.class).map(LogGroupDeclarationCheck::resolveIdentifiersFromProperty).orElse(Collections.emptySet());
    }

    private static Set<String> resolveIdentifiersFromProperty(CloudformationTree property) {
        if (property.tag().endsWith("str")) {
            String value = ((ScalarTree)property).value();
            return Collections.singleton(value.substring(value.lastIndexOf("/") + 1));
        }
        return FunctionReferenceCollector.get(property);
    }

    private static boolean matchResourceIdentifier(Set<String> identifiers, AbstractResourceCheck.Resource resource) {
        return identifiers.contains(resource.name().value()) || identifiers.contains(LogGroupDeclarationCheck.functionName(resource).orElse(null));
    }

    private static Optional<String> functionName(AbstractResourceCheck.Resource resource) {
        return PropertyUtils.value((Tree)resource.properties(), (String)"FunctionName").filter(ScalarTree.class::isInstance).map(s -> ((ScalarTree)s).value());
    }

    private static boolean isRelevantResource(AbstractResourceCheck.Resource resource) {
        return RELEVANT_RESOURCE.contains(TextUtils.getValue((Tree)resource.type()).orElse(null)) && !LogGroupDeclarationCheck.hasLogEvent(resource);
    }

    private static boolean hasLogEvent(AbstractResourceCheck.Resource resource) {
        return PropertyUtils.value((Tree)resource.properties(), (String)"Events").filter(MappingTree.class::isInstance).map(e -> ((MappingTree)e).elements()).orElse(Collections.emptyList()).stream().map(TupleTree::value).anyMatch(e -> XPathUtils.getSingleTree(e, "/Properties/LogGroupName").isPresent());
    }

    static class FunctionReferenceCollector
    extends TreeVisitor<TreeContext> {
        private static final Pattern SUB_PARAMETERS = Pattern.compile("\\$\\{([a-zA-Z0-9.]+)}|([a-zA-Z0-9.]+)");
        private final Set<String> references = new HashSet<String>();

        public FunctionReferenceCollector() {
            this.register(ScalarTree.class, (ctx, tree) -> {
                if ("!Sub".equals(tree.tag())) {
                    this.collectSubParameters((CloudformationTree)tree);
                } else if ("!Ref".equals(tree.tag())) {
                    this.collectRefParameter((CloudformationTree)tree);
                }
            });
            this.register(TupleTree.class, (ctx, tree) -> {
                if (TextUtils.isValue((Tree)tree.key(), (String)"Fn::Sub").isTrue()) {
                    this.collectSubParameters(tree.value());
                } else if (TextUtils.isValue((Tree)tree.key(), (String)"Ref").isTrue()) {
                    this.collectRefParameter(tree.value());
                }
            });
        }

        private void collectSubParameters(CloudformationTree sub) {
            if (sub instanceof ScalarTree) {
                Matcher m = SUB_PARAMETERS.matcher(((ScalarTree)sub).value());
                while (m.find()) {
                    if (m.group(1) != null) {
                        this.references.add(m.group(1));
                        continue;
                    }
                    this.references.add(m.group(2));
                }
            }
        }

        private void collectRefParameter(CloudformationTree ref) {
            if (ref instanceof ScalarTree) {
                this.references.add(((ScalarTree)ref).value());
            }
        }

        public static Set<String> get(CloudformationTree logGroupNameProperty) {
            FunctionReferenceCollector collector = new FunctionReferenceCollector();
            collector.scan(new TreeContext(), logGroupNameProperty);
            return collector.references;
        }
    }
}

