/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6303")
public class DisabledRDSEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted databases is safe here.";
    private static final String SECONDARY_MESSAGE = "Related RDS DBInstance";
    private static final String STORAGE_ENCRYPTED = "StorageEncrypted";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::RDS::DBInstance")) {
            return;
        }
        Optional maybeEncryption = PropertyUtils.get((Tree)resource.properties(), (String)STORAGE_ENCRYPTED);
        if (maybeEncryption.isPresent()) {
            PropertyTree encryption = (PropertyTree)maybeEncryption.get();
            if (TextUtils.isValueFalse((Tree)encryption.value())) {
                ctx.reportIssue((HasTextRange)encryption.key(), MESSAGE, new SecondaryLocation((HasTextRange)resource.type(), SECONDARY_MESSAGE));
            }
        } else {
            ctx.reportIssue((HasTextRange)resource.type(), MESSAGE);
        }
    }
}

