/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.api.tree.MappingTree;
import org.sonar.iac.cloudformation.api.tree.SequenceTree;
import org.sonar.iac.cloudformation.api.tree.TupleTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6258")
public class DisabledLoggingCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that disabling logging is safe here.";
    private static final List<String> MSK_LOGGER = Arrays.asList("CloudWatchLogs", "Firehose", "S3");
    private static final String MESSAGE_OMITTING_FORMAT = "Omitting %s makes logs incomplete. Make sure it is safe here.";
    private static final String ENABLED = "Enabled";
    private static final String ENABLE_CLOUDWATCH_LOGS_EXPORTS_KEY = "EnableCloudwatchLogsExports";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (DisabledLoggingCheck.isS3Bucket(resource)) {
            DisabledLoggingCheck.checkS3Bucket(ctx, resource);
        } else if (resource.isType("AWS::ApiGateway::Stage")) {
            DisabledLoggingCheck.checkApiGatewayStage(ctx, resource);
        } else if (resource.isType("AWS::ApiGatewayV2::Stage")) {
            DisabledLoggingCheck.checkApiGatewayV2Stage(ctx, resource);
        } else if (resource.isType("AWS::MSK::Cluster")) {
            DisabledLoggingCheck.checkMskCluster(ctx, resource);
        } else if (resource.isType("AWS::Neptune::DBCluster")) {
            DisabledLoggingCheck.checkNeptuneDbCluster(ctx, resource);
        } else if (resource.isType("AWS::DocDB::DBCluster")) {
            DisabledLoggingCheck.checkDocDbCluster(ctx, resource);
        } else if (resource.isType("AWS::AmazonMQ::Broker")) {
            DisabledLoggingCheck.checkAmazonMQBroker(ctx, resource);
        } else if (resource.isType("AWS::Redshift::Cluster")) {
            DisabledLoggingCheck.checkRedshiftCluster(ctx, resource);
        } else if (resource.isType("AWS::Elasticsearch::Domain") || resource.isType("AWS::OpenSearchService::Domain")) {
            DisabledLoggingCheck.checkSearchDomain(ctx, resource);
        } else if (resource.isType("AWS::CloudFront::Distribution")) {
            DisabledLoggingCheck.checkCloudFrontDistribution(ctx, resource);
        } else if (resource.isType("AWS::ElasticLoadBalancing::LoadBalancer")) {
            DisabledLoggingCheck.checkElasticLoadBalancer(ctx, resource);
        } else if (resource.isType("AWS::ElasticLoadBalancingV2::LoadBalancer")) {
            DisabledLoggingCheck.checkElasticLoadBalancerV2(ctx, resource);
        }
    }

    private static void checkS3Bucket(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        CloudformationTree properties = resource.properties();
        if (PropertyUtils.value((Tree)properties, (String)"LoggingConfiguration").isEmpty() && !DisabledLoggingCheck.isMaybeLoggingBucket(properties)) {
            ctx.reportIssue((HasTextRange)resource.type(), DisabledLoggingCheck.omittingMessage("LoggingConfiguration"));
        }
    }

    private static boolean isMaybeLoggingBucket(@Nullable CloudformationTree properties) {
        Optional acl = PropertyUtils.value((Tree)properties, (String)"AccessControl");
        if (acl.isPresent()) {
            Optional scalarValue = TextUtils.getValue((Tree)((Tree)acl.get()));
            return scalarValue.map(s -> s.equals("LogDeliveryWrite")).orElse(true);
        }
        return false;
    }

    private static void checkApiGatewayStage(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        CloudformationTree properties = resource.properties();
        PropertyUtils.value((Tree)properties, (String)"TracingEnabled").ifPresentOrElse(f -> DisabledLoggingCheck.reportOnFalse(ctx, f), () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage("TracingEnabled")));
        DisabledLoggingCheck.reportOnMissingProperty(ctx, properties, "AccessLogSetting", resource.type());
    }

    private static void checkApiGatewayV2Stage(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        DisabledLoggingCheck.reportOnMissingProperty(ctx, resource.properties(), "AccessLogSettings", resource.type());
    }

    private static void checkMskCluster(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)"LoggingInfo").ifPresentOrElse(info -> PropertyUtils.get((Tree)info.value(), (String)"BrokerLogs").ifPresentOrElse(logs -> DisabledLoggingCheck.checkMskLogs(ctx, logs), () -> ctx.reportIssue((HasTextRange)info.key(), DisabledLoggingCheck.omittingMessage("BrokerLogs"))), () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage("LoggingInfo")));
    }

    private static void checkMskLogs(CheckContext ctx, PropertyTree logs) {
        if (MSK_LOGGER.stream().noneMatch(name -> PropertyUtils.value((Tree)logs.value(), (String)name).filter(DisabledLoggingCheck::isLogEnabled).isPresent())) {
            ctx.reportIssue((HasTextRange)logs.key(), MESSAGE);
        }
    }

    private static boolean isLogEnabled(Tree logger) {
        return PropertyUtils.value((Tree)logger, (String)ENABLED).filter(TextUtils::isValueFalse).isEmpty();
    }

    private static void checkNeptuneDbCluster(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)ENABLE_CLOUDWATCH_LOGS_EXPORTS_KEY).ifPresentOrElse(exportsValue -> {
            if (exportsValue instanceof SequenceTree && ((SequenceTree)exportsValue).elements().isEmpty()) {
                ctx.reportIssue((HasTextRange)exportsValue, MESSAGE);
            }
        }, () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage(ENABLE_CLOUDWATCH_LOGS_EXPORTS_KEY)));
    }

    private static void checkDocDbCluster(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)ENABLE_CLOUDWATCH_LOGS_EXPORTS_KEY).ifPresentOrElse(exportsProperty -> {
            if (exportsProperty.value() instanceof SequenceTree && DisabledLoggingCheck.containsOnlyStringsWithoutAudit((SequenceTree)exportsProperty.value())) {
                ctx.reportIssue((HasTextRange)exportsProperty.key(), MESSAGE);
            }
        }, () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage(ENABLE_CLOUDWATCH_LOGS_EXPORTS_KEY)));
    }

    private static boolean containsOnlyStringsWithoutAudit(SequenceTree exports) {
        return exports.elements().stream().allMatch(export -> export.tag().endsWith("str") && TextUtils.isValue((Tree)export, (String)"audit").isFalse());
    }

    private static void checkAmazonMQBroker(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)"Logs").ifPresentOrElse(logs -> {
            if (logs.value() instanceof MappingTree && DisabledLoggingCheck.containsOnlyFalse((MappingTree)logs.value())) {
                ctx.reportIssue((HasTextRange)logs.key(), MESSAGE);
            }
        }, () -> DisabledLoggingCheck.reportResource(ctx, resource, MESSAGE));
    }

    private static boolean containsOnlyFalse(MappingTree logs) {
        return logs.elements().stream().map(TupleTree::value).allMatch(TextUtils::isValueFalse);
    }

    private static void checkRedshiftCluster(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (PropertyUtils.isMissing((Tree)resource.properties(), (String)"LoggingProperties")) {
            DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage("LoggingProperties"));
        }
    }

    private static void checkSearchDomain(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)"LogPublishingOptions").ifPresentOrElse(logs -> DisabledLoggingCheck.checkEnabledAuditLogAvailability(ctx, logs), () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage("LogPublishingOptions")));
    }

    private static void checkEnabledAuditLogAvailability(CheckContext ctx, PropertyTree logs) {
        PropertyUtils.value((Tree)logs.value(), (String)"AUDIT_LOGS").flatMap(v -> PropertyUtils.value((Tree)v, (String)ENABLED)).ifPresentOrElse(auditLogsEnable -> DisabledLoggingCheck.reportOnFalse(ctx, auditLogsEnable), () -> ctx.reportIssue((HasTextRange)logs.key(), DisabledLoggingCheck.omittingMessage("AUDIT_LOGS")));
    }

    private static void checkCloudFrontDistribution(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)"DistributionConfig").ifPresentOrElse(config -> DisabledLoggingCheck.reportOnMissingProperty(ctx, config.value(), "Logging", config.key()), () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage("DistributionConfig")));
    }

    private static void checkElasticLoadBalancer(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)"AccessLoggingPolicy").ifPresentOrElse(policy -> PropertyUtils.value((Tree)policy, (String)ENABLED).ifPresent(e -> DisabledLoggingCheck.reportOnFalse(ctx, e)), () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage("AccessLoggingPolicy")));
    }

    private static void checkElasticLoadBalancerV2(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.get((Tree)resource.properties(), (String)"LoadBalancerAttributes").ifPresentOrElse(attributes -> DisabledLoggingCheck.getAccessLogsAttribute(attributes.value()).ifPresentOrElse(value -> DisabledLoggingCheck.reportOnFalse(ctx, value), () -> ctx.reportIssue((HasTextRange)attributes.key(), MESSAGE)), () -> DisabledLoggingCheck.reportResource(ctx, resource, DisabledLoggingCheck.omittingMessage("LoadBalancerAttributes")));
    }

    private static Optional<Tree> getAccessLogsAttribute(Tree attributes) {
        if (attributes instanceof SequenceTree) {
            return ((SequenceTree)attributes).elements().stream().filter(attribute -> TextUtils.isValue((Tree)PropertyUtils.valueOrNull((Tree)attribute, (String)"Key"), (String)"access_logs.s3.enabled").isTrue()).map(attribute -> PropertyUtils.value((Tree)attribute, (String)"Value")).findFirst().orElse(Optional.empty());
        }
        return Optional.empty();
    }

    private static void reportOnMissingProperty(CheckContext ctx, @Nullable Tree properties, String property, Tree raiseOn) {
        if (PropertyUtils.isMissing((Tree)properties, (String)property)) {
            ctx.reportIssue((HasTextRange)raiseOn, DisabledLoggingCheck.omittingMessage(property));
        }
    }

    private static void reportOnFalse(CheckContext ctx, Tree tree) {
        if (TextUtils.isValueFalse((Tree)tree)) {
            ctx.reportIssue((HasTextRange)tree, MESSAGE);
        }
    }

    private static String omittingMessage(String missingProperty) {
        return String.format(MESSAGE_OMITTING_FORMAT, missingProperty);
    }
}

