/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6308")
public class DisabledESDomainEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted Elasticsearch domains is safe here.";
    private static final String SECONDARY_MESSAGE = "Related domain";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::Elasticsearch::Domain")) {
            return;
        }
        CloudformationTree resourceType = resource.type();
        Optional maybeEncryption = PropertyUtils.get((Tree)resource.properties(), (String)"EncryptionAtRestOptions");
        if (maybeEncryption.isPresent()) {
            PropertyTree encryption = (PropertyTree)maybeEncryption.get();
            Optional maybeEnabled = PropertyUtils.get((Tree)encryption.value(), (String)"Enabled");
            if (maybeEnabled.isPresent()) {
                PropertyTree enabled = (PropertyTree)maybeEnabled.get();
                if (TextUtils.isValueFalse((Tree)enabled.value())) {
                    ctx.reportIssue((HasTextRange)enabled.key(), MESSAGE, new SecondaryLocation((HasTextRange)resourceType, SECONDARY_MESSAGE));
                }
                return;
            }
            ctx.reportIssue((HasTextRange)encryption.key(), MESSAGE, new SecondaryLocation((HasTextRange)resourceType, SECONDARY_MESSAGE));
            return;
        }
        ctx.reportIssue((HasTextRange)resourceType, MESSAGE);
    }
}

