/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.api.tree.MappingTree;
import org.sonar.iac.cloudformation.api.tree.ScalarTree;
import org.sonar.iac.cloudformation.api.tree.SequenceTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.XPathUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S5332")
public class ClearTextProtocolsCheck
extends AbstractResourceCheck {
    private static final String MESSAGE_PROTOCOL_FORMAT = "Using %s protocol is insecure. Use %s instead.";
    private static final String MESSAGE_CLEAR_TEXT = "Make sure allowing clear-text traffic is safe here.";
    private static final String MESSAGE_OMITTING_FORMAT = "Omitting %s enables clear-text traffic. Make sure it is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::MSK::Cluster")) {
            ClearTextProtocolsCheck.checkMskCluster(ctx, resource);
        } else if (resource.isType("AWS::OpenSearchService::Domain") || resource.isType("AWS::Elasticsearch::Domain")) {
            ClearTextProtocolsCheck.checkSearchDomain(ctx, resource);
        } else if (resource.isType("AWS::ElasticLoadBalancingV2::Listener")) {
            ClearTextProtocolsCheck.checkLoadBalancingListener(ctx, resource);
        } else if (resource.isType("AWS::ECS::TaskDefinition")) {
            ClearTextProtocolsCheck.checkEcsTaskDefinition(ctx, resource);
        } else if (resource.isType("AWS::ElastiCache::ReplicationGroup")) {
            ClearTextProtocolsCheck.checkESReplicationGroup(ctx, resource);
        } else if (resource.isType("AWS::Kinesis::Stream")) {
            ClearTextProtocolsCheck.checkKinesisStream(ctx, resource);
        }
    }

    private static void checkMskCluster(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)"EncryptionInfo", MappingTree.class).flatMap(e -> PropertyUtils.value((Tree)e, (String)"EncryptionInTransit", MappingTree.class)).ifPresent(e -> {
            ClearTextProtocolsCheck.checkClientBroker(ctx, e);
            ClearTextProtocolsCheck.reportOnFalseProperty(ctx, e, "InCluster", MESSAGE_CLEAR_TEXT);
        });
    }

    private static void checkClientBroker(CheckContext ctx, MappingTree e) {
        PropertyUtils.value((Tree)e, (String)"ClientBroker", ScalarTree.class).filter(clientBroker -> !"TLS".equals(clientBroker.value())).ifPresent(clientBroker -> ctx.reportIssue((HasTextRange)clientBroker, String.format(MESSAGE_PROTOCOL_FORMAT, clientBroker.value(), "TLS")));
    }

    private static void checkSearchDomain(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)"NodeToNodeEncryptionOptions").ifPresentOrElse(v -> ClearTextProtocolsCheck.reportOnFalseProperty(ctx, v, "Enabled", MESSAGE_CLEAR_TEXT), () -> ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage("NodeToNodeEncryptionOptions")));
        PropertyUtils.get((Tree)resource.properties(), (String)"DomainEndpointOptions").ifPresentOrElse(v -> ClearTextProtocolsCheck.checkDomainEnforceHttp(ctx, v), () -> ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage("DomainEndpointOptions")));
    }

    private static void checkDomainEnforceHttp(CheckContext ctx, PropertyTree domainEndpointOptions) {
        String enforceHTTPSKey = "EnforceHTTPS";
        if (PropertyUtils.isMissing((Tree)domainEndpointOptions.value(), (String)enforceHTTPSKey)) {
            ctx.reportIssue((HasTextRange)domainEndpointOptions.key(), ClearTextProtocolsCheck.omittingMessage(enforceHTTPSKey));
        }
        ClearTextProtocolsCheck.reportOnFalseProperty(ctx, domainEndpointOptions.value(), enforceHTTPSKey, MESSAGE_CLEAR_TEXT);
    }

    private static void checkLoadBalancingListener(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        Optional rootProtocol = PropertyUtils.value((Tree)resource.properties(), (String)"Protocol");
        if (rootProtocol.isEmpty() || !TextUtils.isValue((Tree)((Tree)rootProtocol.get()), (String)"HTTP").isTrue()) {
            return;
        }
        Optional defaultActions = PropertyUtils.value((Tree)resource.properties(), (String)"DefaultActions", SequenceTree.class);
        if (defaultActions.isEmpty()) {
            return;
        }
        if (((SequenceTree)defaultActions.get()).elements().stream().anyMatch(a -> ClearTextProtocolsCheck.isFixedResponseOrForwardAction(a) || ClearTextProtocolsCheck.isRedirectToHttpAction(a))) {
            ctx.reportIssue((HasTextRange)rootProtocol.get(), String.format(MESSAGE_PROTOCOL_FORMAT, "HTTP", "HTTPS"));
        }
    }

    private static boolean isFixedResponseOrForwardAction(CloudformationTree action) {
        Tree type = PropertyUtils.valueOrNull((Tree)action, (String)"Type");
        return TextUtils.isValue((Tree)type, (String)"fixed-response").isTrue() || TextUtils.isValue((Tree)type, (String)"forward").isTrue();
    }

    private static boolean isRedirectToHttpAction(CloudformationTree action) {
        return TextUtils.isValue((Tree)PropertyUtils.valueOrNull((Tree)action, (String)"Type"), (String)"redirect").isTrue() && TextUtils.isValue((Tree)XPathUtils.getSingleTree(action, "/RedirectConfig/Protocol").orElse(null), (String)"HTTP").isTrue();
    }

    private static void checkEcsTaskDefinition(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)"Volumes", SequenceTree.class).ifPresent(volumes -> volumes.elements().forEach(v -> ClearTextProtocolsCheck.checkEcsTaskDefinitionVolume(ctx, v)));
    }

    private static void checkEcsTaskDefinitionVolume(CheckContext ctx, CloudformationTree volume) {
        Optional configuration = PropertyUtils.get((Tree)volume, (String)"EFSVolumeConfiguration");
        if (configuration.isEmpty()) {
            return;
        }
        Optional transitEncryption = PropertyUtils.value((Tree)((PropertyTree)configuration.get()).value(), (String)"TransitEncryption");
        if (transitEncryption.isPresent() && TextUtils.isValue((Tree)((Tree)transitEncryption.get()), (String)"DISABLED").isTrue()) {
            ctx.reportIssue((HasTextRange)transitEncryption.get(), MESSAGE_CLEAR_TEXT);
        } else if (transitEncryption.isEmpty()) {
            ctx.reportIssue((HasTextRange)((PropertyTree)configuration.get()).key(), ClearTextProtocolsCheck.omittingMessage("TransitEncryption"));
        }
    }

    private static void checkESReplicationGroup(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        String encryptionPropertyKey = "TransitEncryptionEnabled";
        if (PropertyUtils.isMissing((Tree)resource.properties(), (String)encryptionPropertyKey)) {
            ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage(encryptionPropertyKey));
        } else {
            ClearTextProtocolsCheck.reportOnFalseProperty(ctx, resource.properties(), encryptionPropertyKey, MESSAGE_CLEAR_TEXT);
        }
    }

    private static void checkKinesisStream(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (PropertyUtils.isMissing((Tree)resource.properties(), (String)"StreamEncryption")) {
            ClearTextProtocolsCheck.reportResource(ctx, resource, ClearTextProtocolsCheck.omittingMessage("StreamEncryption"));
        }
    }

    private static void reportOnFalseProperty(CheckContext ctx, @Nullable Tree tree, String propertyName, String message) {
        PropertyUtils.value((Tree)tree, (String)propertyName, ScalarTree.class).filter(TextUtils::isValueFalse).ifPresent(clientBroker -> ctx.reportIssue((HasTextRange)clientBroker, message));
    }

    private static String omittingMessage(String domainEndpointOptions) {
        return String.format(MESSAGE_OMITTING_FORMAT, domainEndpointOptions);
    }
}

