/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.cloudformation.api.tree.CloudformationTree;
import org.sonar.iac.cloudformation.api.tree.ScalarTree;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.XPathUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;

@Rule(key="S6273")
public class AwsTagNameConventionCheck
extends AbstractResourceCheck {
    protected static final String MESSAGE = "Rename tag key \"%s\" to match the regular expression \"%s\".";
    public static final String DEFAULT = "^([A-Z][A-Za-z]*:)*([A-Z][A-Za-z]*)$";
    protected Pattern pattern;
    @RuleProperty(key="format", description="Regular expression used to check the tag keys against.", defaultValue="^([A-Z][A-Za-z]*:)*([A-Z][A-Za-z]*)$")
    public String format = "^([A-Z][A-Za-z]*:)*([A-Z][A-Za-z]*)$";

    @Override
    public void initialize(InitContext init) {
        this.pattern = Pattern.compile(this.format);
        super.initialize(init);
    }

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        CloudformationTree properties = resource.properties();
        if (properties != null) {
            AwsTagNameConventionCheck.getTagKeyStream(properties).filter(this::isMismatchingKey).forEach(key -> ctx.reportIssue((HasTextRange)key, String.format(MESSAGE, key.value(), this.format)));
        }
    }

    private static Stream<ScalarTree> getTagKeyStream(CloudformationTree properties) {
        return XPathUtils.getTrees(properties, "/Tags[]/Key").stream().filter(ScalarTree.class::isInstance).map(ScalarTree.class::cast);
    }

    private boolean isMismatchingKey(ScalarTree tagKey) {
        return !this.pattern.matcher(tagKey.value()).matches();
    }
}

