/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.reports;

import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.iac.cloudformation.plugin.CfnLintRulesDefinition;
import org.sonar.iac.common.reports.AbstractJsonReportImporter;
import org.sonar.iac.common.warnings.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;

public class CfnLintImporter
extends AbstractJsonReportImporter {
    public static final String LINE_NUMBER_KEY = "LineNumber";
    public static final String COLUMN_NUMBER_KEY = "ColumnNumber";
    private static final String MESSAGE_PREFIX = "Cfn-lint report importing: ";

    public CfnLintImporter(SensorContext context, AnalysisWarningsWrapper analysisWarnings) {
        super(context, analysisWarnings, MESSAGE_PREFIX);
    }

    protected NewExternalIssue toExternalIssue(JSONObject issueJson) {
        String path = (String)issueJson.get((Object)"Filename");
        InputFile inputFile = this.inputFile(path);
        String ruleId = (String)((JSONObject)issueJson.get((Object)"Rule")).get((Object)"Id");
        if (!CfnLintRulesDefinition.RULE_LOADER.ruleKeys().contains(ruleId)) {
            ruleId = "cfn-lint.fallback";
        }
        NewExternalIssue externalIssue = this.context.newExternalIssue().ruleId(ruleId).type(CfnLintRulesDefinition.RULE_LOADER.ruleType(ruleId)).engineId("cfn-lint").severity(CfnLintRulesDefinition.RULE_LOADER.ruleSeverity(ruleId)).remediationEffortMinutes(CfnLintRulesDefinition.RULE_LOADER.ruleConstantDebtMinutes(ruleId));
        externalIssue.at(CfnLintImporter.getIssueLocation(issueJson, externalIssue, inputFile));
        return externalIssue;
    }

    private static NewIssueLocation getIssueLocation(JSONObject issueJson, NewExternalIssue externalIssue, InputFile inputFile) {
        TextRange range;
        JSONObject issueJsonLocation = (JSONObject)issueJson.get((Object)"Location");
        JSONObject start = (JSONObject)issueJsonLocation.get((Object)"Start");
        JSONObject end = (JSONObject)issueJsonLocation.get((Object)"End");
        try {
            range = inputFile.newRange(CfnLintImporter.asInt((Object)start.get((Object)LINE_NUMBER_KEY)), CfnLintImporter.asInt((Object)start.get((Object)COLUMN_NUMBER_KEY)) - 1, CfnLintImporter.asInt((Object)end.get((Object)LINE_NUMBER_KEY)), CfnLintImporter.asInt((Object)end.get((Object)COLUMN_NUMBER_KEY)) - 1);
        }
        catch (IllegalArgumentException e) {
            range = inputFile.selectLine(CfnLintImporter.asInt((Object)end.get((Object)LINE_NUMBER_KEY)));
        }
        return externalIssue.newLocation().message((String)issueJson.get((Object)"Message")).on((InputComponent)inputFile).at(range);
    }
}

