/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.PolicyUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.common.yaml.tree.SequenceTree;

@Rule(key="S6302")
public class PrivilegePolicyCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting all privileges is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PolicyUtils.getPolicies((Tree)resource.properties()).stream().forEach(policy -> PrivilegePolicyCheck.checkInsecurePolicy(ctx, policy));
    }

    private static void checkInsecurePolicy(CheckContext ctx, Policy policy) {
        PolicyValidator.findInsecureStatements(policy).stream().forEach(statement -> ctx.reportIssue((HasTextRange)statement.action, MESSAGE, new SecondaryLocation((HasTextRange)statement.effect, SECONDARY_MESSAGE)));
    }

    private static class PolicyValidator {
        private PolicyValidator() {
        }

        static List<InsecureStatement> findInsecureStatements(Policy policy) {
            ArrayList<InsecureStatement> result = new ArrayList<InsecureStatement>();
            for (Policy.Statement statement : policy.statement()) {
                statement.action().flatMap(PolicyValidator::findInsecureAction).ifPresent(action -> statement.effect().filter(PolicyValidator::isAllowEffect).ifPresent(effect -> result.add(new InsecureStatement((Tree)action, (Tree)effect))));
                statement.notAction().flatMap(PolicyValidator::findInsecureAction).ifPresent(notAction -> statement.effect().filter(PolicyValidator::isDenyEffect).ifPresent(effect -> result.add(new InsecureStatement((Tree)notAction, (Tree)effect))));
            }
            return result;
        }

        private static Optional<Tree> findInsecureAction(Tree action) {
            if (action instanceof SequenceTree) {
                return ((SequenceTree)action).elements().stream().filter(PolicyValidator::applyToAnyAction).map(Tree.class::cast).findAny();
            }
            if (PolicyValidator.applyToAnyAction(action)) {
                return Optional.of(action);
            }
            return Optional.empty();
        }

        private static boolean applyToAnyAction(Tree action) {
            return TextUtils.isValue((Tree)action, (String)"*").isTrue();
        }

        private static boolean isAllowEffect(Tree effect) {
            return TextUtils.isValue((Tree)effect, (String)"Allow").isTrue();
        }

        private static boolean isDenyEffect(Tree effect) {
            return TextUtils.isValue((Tree)effect, (String)"Deny").isTrue();
        }
    }

    private static class InsecureStatement {
        final Tree action;
        final Tree effect;

        public InsecureStatement(Tree action, Tree effect) {
            this.action = action;
            this.effect = effect;
        }
    }
}

