/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6265")
public class BucketsAccessCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting access to %s group is safe here.";
    private static final String SECONDARY_MSG = "Related bucket";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!BucketsAccessCheck.isS3Bucket(resource)) {
            return;
        }
        PropertyUtils.value((Tree)resource.properties(), (String)"AccessControl").ifPresent(acl -> {
            String aclValue = TextUtils.getValue((Tree)acl).orElse(null);
            if ("PublicReadWrite".equals(aclValue) || "PublicRead".equals(aclValue)) {
                ctx.reportIssue((HasTextRange)acl, String.format(MESSAGE, "AllUsers"), new SecondaryLocation((HasTextRange)resource.type(), SECONDARY_MSG));
            } else if ("AuthenticatedRead".equals(aclValue)) {
                ctx.reportIssue((HasTextRange)acl, String.format(MESSAGE, "AuthenticatedUsers"), new SecondaryLocation((HasTextRange)resource.type(), SECONDARY_MSG));
            }
        });
    }
}

