/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;

@Rule(key="S6319")
public class UnencryptedSageMakerNotebookCheck
extends AbstractResourceCheck {
    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::SageMaker::NotebookInstance")) {
            return;
        }
        if (PropertyUtils.isMissing((Tree)resource.properties(), (String)"KmsKeyId")) {
            ctx.reportIssue((HasTextRange)resource.type(), "Omitting \"KmsKeyId\" disables encryption of SageMaker notebook instances. Make sure it is safe here.");
        }
    }
}

