/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6333")
public class PublicApiCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure creating a public API is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::ApiGateway::Method")) {
            PublicApiCheck.checkApiGatewayMethod(ctx, resource);
        } else if (resource.isType("AWS::Serverless::Api")) {
            PublicApiCheck.checkServerlessApi(ctx, resource);
        } else if (resource.isType("AWS::Serverless::HttpApi")) {
            PublicApiCheck.checkServerlessHttpApi(ctx, resource);
        }
    }

    private static void checkApiGatewayMethod(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        PropertyUtils.value((Tree)resource.properties(), (String)"AuthorizationType").filter(typeTree -> TextUtils.isValue((Tree)typeTree, (String)"NONE").isTrue()).ifPresent(typeTree -> ctx.reportIssue((HasTextRange)typeTree, MESSAGE, new SecondaryLocation((HasTextRange)resource.type(), "Related method")));
    }

    private static void checkServerlessApi(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        Optional optionalAuthProperty = PropertyUtils.value((Tree)resource.properties(), (String)"Auth");
        if (!optionalAuthProperty.isPresent()) {
            ctx.reportIssue((HasTextRange)resource.type(), MESSAGE);
            return;
        }
        Tree authProperty = (Tree)optionalAuthProperty.get();
        Optional keyRequirementProperty = PropertyUtils.value((Tree)authProperty, (String)"ApiKeyRequired");
        if (keyRequirementProperty.isPresent() && TextUtils.isValueFalse((Tree)((Tree)keyRequirementProperty.get())) && PublicApiCheck.noRequiredAuthPropertySet(authProperty)) {
            ctx.reportIssue((HasTextRange)keyRequirementProperty.get(), MESSAGE, new SecondaryLocation((HasTextRange)resource.type(), "Related API"));
        }
    }

    private static void checkServerlessHttpApi(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        Optional optionalAuthProperty = PropertyUtils.value((Tree)resource.properties(), (String)"Auth");
        if (!optionalAuthProperty.isPresent()) {
            ctx.reportIssue((HasTextRange)resource.type(), MESSAGE);
        }
    }

    private static boolean noRequiredAuthPropertySet(Tree authProperty) {
        return Stream.of("ResourcePolicy", "Authorizers", "DefaultAuthorizer").noneMatch(p -> PropertyUtils.has((Tree)authProperty, (String)p).isTrue());
    }
}

