/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.plugin;

import java.io.File;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.cloudformation.checks.CloudformationCheckList;
import org.sonar.iac.cloudformation.parser.CloudformationParser;
import org.sonar.iac.cloudformation.plugin.CloudformationLanguage;
import org.sonar.iac.cloudformation.reports.CfnLintImporter;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.FileIdentificationPredicate;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.warnings.AnalysisWarningsWrapper;
import org.sonar.iac.common.warnings.DefaultAnalysisWarningsWrapper;
import org.sonar.iac.common.yaml.YamlSensor;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

public class CloudformationSensor
extends YamlSensor {
    private final AnalysisWarningsWrapper analysisWarnings;

    public CloudformationSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, CloudformationLanguage language) {
        this(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, language, DefaultAnalysisWarningsWrapper.NOOP_ANALYSIS_WARNINGS);
    }

    public CloudformationSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, CloudformationLanguage language, AnalysisWarningsWrapper analysisWarnings) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, (Language)language, CloudformationCheckList.checks());
        this.analysisWarnings = analysisWarnings;
    }

    protected TreeParser<Tree> treeParser() {
        return new CloudformationParser();
    }

    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        return new FileIdentificationPredicate(sensorContext.config().get("sonar.cloudformation.file.identifier").orElse(""));
    }

    protected String repositoryKey() {
        return "cloudformation";
    }

    protected void importExternalReports(SensorContext sensorContext) {
        ExternalReportProvider.getReportFiles((SensorContext)sensorContext, (String)"sonar.cloudformation.cfn-lint.reportPaths").forEach(report -> new CfnLintImporter(sensorContext, this.analysisWarnings).importReport((File)report));
    }

    protected String getActivationSettingKey() {
        return "sonar.cloudformation.activate";
    }
}

