/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6364")
public class ShortBackupRetentionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that defining a short backup retention duration is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"BackupRetentionPeriod\" sets the backup retention period to 1 day. Make sure that defining a short backup retention duration is safe here.";
    private static final int DEFAULT = 7;
    private static final Set<String> ENGINES_EXCEPTION = Set.of("aurora", "aurora-mysql", "aurora-postgresql");
    @RuleProperty(key="backup_retention_duration", defaultValue="7", description="Minimum backup retention duration in days")
    int backupRetentionDuration = 7;

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::RDS::DBInstance") && PropertyUtils.isMissing((Tree)resource.properties(), (String)"SourceDBInstanceIdentifier") && ShortBackupRetentionCheck.isNotEngineException(resource) || resource.isType("AWS::RDS::DBCluster")) {
            ShortBackupRetentionCheck.checkBackupRetentionPeriod(ctx, resource, this.backupRetentionDuration);
        }
    }

    private static boolean isNotEngineException(AbstractResourceCheck.Resource resource) {
        return PropertyUtils.has((Tree)resource.properties(), (String)"Engine").isFalse() || PropertyUtils.valueIs((Tree)resource.properties(), (String)"Engine", tree -> TextUtils.getValue((Tree)tree).filter(ENGINES_EXCEPTION::contains).isEmpty());
    }

    private static void checkBackupRetentionPeriod(CheckContext ctx, AbstractResourceCheck.Resource resource, int minPeriod) {
        PropertyUtils.value((Tree)resource.properties(), (String)"BackupRetentionPeriod").ifPresentOrElse(period -> TextUtils.getIntValue((Tree)period).filter(currentPeriod -> currentPeriod < minPeriod).ifPresent(currentPeriod -> ctx.reportIssue((HasTextRange)period, MESSAGE)), () -> {
            if (minPeriod != 1) {
                ShortBackupRetentionCheck.reportResource(ctx, resource, OMITTING_MESSAGE);
            }
        });
    }
}

