/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.PolicyUtils;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.common.checks.policy.PolicyValidator;

@Rule(key="S6304")
public class ResourceAccessPolicyCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure granting access to all resources is safe here.";
    private static final String EFFECT_MESSAGE = "Related effect";
    private static final String ACTION_MESSAGE = "Related action";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::KMS::Key")) {
            return;
        }
        PolicyUtils.getPolicies((Tree)resource.properties()).forEach(policy -> ResourceAccessPolicyCheck.checkInsecurePolicy(ctx, policy));
    }

    private static void checkInsecurePolicy(CheckContext ctx, Policy policy) {
        PolicyValidator.findInsecureStatements((Policy)policy).forEach(statement -> ctx.reportIssue((HasTextRange)statement.resource, MESSAGE, List.of(new SecondaryLocation((HasTextRange)statement.effect, EFFECT_MESSAGE), new SecondaryLocation((HasTextRange)statement.action, ACTION_MESSAGE))));
    }
}

