/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.reports;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.iac.cloudformation.plugin.CfnLintRulesDefinition;
import org.sonar.iac.common.warnings.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class CfnLintImporter {
    private static final Logger LOG = Loggers.get(CfnLintImporter.class);
    private static final JSONParser jsonParser = new JSONParser();
    public static final String LINE_NUMBER_KEY = "LineNumber";
    public static final String COLUMN_NUMBER_KEY = "ColumnNumber";
    private final SensorContext context;
    private final AnalysisWarningsWrapper analysisWarnings;
    private Set<String> unresolvedPaths;

    public CfnLintImporter(SensorContext context, AnalysisWarningsWrapper analysisWarnings) {
        this.context = context;
        this.analysisWarnings = analysisWarnings;
    }

    public void importReport(File reportFile) {
        if (!reportFile.isFile()) {
            String message = String.format("Cfn-lint report importing: path does not seem to point to a file %s", reportFile.getPath());
            CfnLintImporter.logWarnAndAddUnique(this.analysisWarnings, message);
            return;
        }
        this.parseJson(reportFile).ifPresent(issuesJson -> {
            this.unresolvedPaths = new LinkedHashSet<String>();
            int failedToSaveIssues = this.saveIssues((JSONArray)issuesJson);
            if (failedToSaveIssues > 0) {
                this.addWarning(reportFile.getPath(), issuesJson.size(), failedToSaveIssues);
            }
        });
    }

    private Optional<JSONArray> parseJson(File reportFile) {
        JSONArray issuesJson = null;
        try {
            issuesJson = (JSONArray)jsonParser.parse((Reader)Files.newBufferedReader(reportFile.toPath()));
        }
        catch (IOException e) {
            String message = String.format("Cfn-lint report importing: could not read report file %s", reportFile.getPath());
            CfnLintImporter.logWarnAndAddUnique(this.analysisWarnings, message);
        }
        catch (ParseException e) {
            String message = String.format("Cfn-lint report importing: could not parse file as JSON %s", reportFile.getPath());
            CfnLintImporter.logWarnAndAddUnique(this.analysisWarnings, message);
        }
        catch (RuntimeException e) {
            String message = String.format("Cfn-lint report importing: file is expected to contain a JSON array but didn't %s", reportFile.getPath());
            CfnLintImporter.logWarnAndAddUnique(this.analysisWarnings, message);
        }
        return Optional.ofNullable(issuesJson);
    }

    private int saveIssues(JSONArray issuesJson) {
        int failedToSaveIssues = 0;
        for (Object issueJson : issuesJson) {
            try {
                this.saveIssue((JSONObject)issueJson);
            }
            catch (RuntimeException e) {
                LOG.debug("Cfn-lint report importing: failed to save issue", (Object)e);
                ++failedToSaveIssues;
            }
        }
        return failedToSaveIssues;
    }

    private void saveIssue(JSONObject issueJson) {
        String path = (String)issueJson.get((Object)"Filename");
        FilePredicates predicates = this.context.fileSystem().predicates();
        InputFile inputFile = this.context.fileSystem().inputFile(predicates.or(predicates.hasAbsolutePath(path), predicates.hasRelativePath(path)));
        if (inputFile == null) {
            this.unresolvedPaths.add(path);
        }
        Objects.requireNonNull(inputFile);
        String ruleId = (String)((JSONObject)issueJson.get((Object)"Rule")).get((Object)"Id");
        if (!CfnLintRulesDefinition.RULE_LOADER.ruleKeys().contains(ruleId)) {
            ruleId = "cfn-lint.fallback";
        }
        NewExternalIssue externalIssue = this.context.newExternalIssue().ruleId(ruleId).type(CfnLintRulesDefinition.RULE_LOADER.ruleType(ruleId)).engineId("cfn-lint").severity(CfnLintRulesDefinition.RULE_LOADER.ruleSeverity(ruleId)).remediationEffortMinutes(CfnLintRulesDefinition.RULE_LOADER.ruleConstantDebtMinutes(ruleId));
        externalIssue.at(CfnLintImporter.getIssueLocation(issueJson, externalIssue, inputFile));
        externalIssue.save();
    }

    private void addWarning(String path, int total, int failed) {
        StringBuilder sb = new StringBuilder(String.format("Cfn-lint report importing: could not save %d out of %d issues from %s.", failed, total, path));
        if (!this.unresolvedPaths.isEmpty()) {
            sb.append(" Some file paths could not be resolved: ");
            sb.append(this.unresolvedPaths.stream().limit(2L).collect(Collectors.joining(", ")));
            sb.append(this.unresolvedPaths.size() > 2 ? ", ..." : "");
        }
        CfnLintImporter.logWarnAndAddUnique(this.analysisWarnings, sb.toString());
    }

    private static NewIssueLocation getIssueLocation(JSONObject issueJson, NewExternalIssue externalIssue, InputFile inputFile) {
        TextRange range;
        JSONObject issueJsonLocation = (JSONObject)issueJson.get((Object)"Location");
        JSONObject start = (JSONObject)issueJsonLocation.get((Object)"Start");
        JSONObject end = (JSONObject)issueJsonLocation.get((Object)"End");
        try {
            range = inputFile.newRange(CfnLintImporter.getIntOutOfJson(start.get((Object)LINE_NUMBER_KEY)), CfnLintImporter.getIntOutOfJson(start.get((Object)COLUMN_NUMBER_KEY)) - 1, CfnLintImporter.getIntOutOfJson(end.get((Object)LINE_NUMBER_KEY)), CfnLintImporter.getIntOutOfJson(end.get((Object)COLUMN_NUMBER_KEY)) - 1);
        }
        catch (IllegalArgumentException e) {
            range = inputFile.selectLine(CfnLintImporter.getIntOutOfJson(end.get((Object)LINE_NUMBER_KEY)));
        }
        return externalIssue.newLocation().message((String)issueJson.get((Object)"Message")).on((InputComponent)inputFile).at(range);
    }

    private static int getIntOutOfJson(Object o) {
        return Math.toIntExact((Long)o);
    }

    private static void logWarnAndAddUnique(AnalysisWarningsWrapper analysisWarnings, String message) {
        LOG.warn(message);
        analysisWarnings.addWarning(message);
    }
}

