/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.PropertyTree;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.yaml.tree.YamlTree;

@Rule(key="S6332")
public class DisabledEFSEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted EFS file systems is safe here.";
    private static final String SECONDARY_MESSAGE = "Related file system";
    private static final String OMITTING_MESSAGE = "Omitting \"Encrypted\" disables EFS file systems encryption. Make sure it is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::EFS::FileSystem")) {
            return;
        }
        YamlTree resourceType = resource.type();
        Optional maybeEncryption = PropertyUtils.get((Tree)resource.properties(), (String)"Encrypted");
        if (maybeEncryption.isPresent()) {
            PropertyTree encryption = (PropertyTree)maybeEncryption.get();
            if (TextUtils.isValueFalse((Tree)encryption.value())) {
                ctx.reportIssue((HasTextRange)encryption.key(), MESSAGE, new SecondaryLocation((HasTextRange)resourceType, SECONDARY_MESSAGE));
            }
        } else {
            ctx.reportIssue((HasTextRange)resourceType, OMITTING_MESSAGE);
        }
    }
}

