/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.plugin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.resources.Language;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.iac.cloudformation.checks.CloudformationCheckList;
import org.sonar.iac.cloudformation.parser.CloudformationConverter;
import org.sonar.iac.cloudformation.plugin.CloudformationLanguage;
import org.sonar.iac.cloudformation.reports.CfnLintImporter;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.yaml.YamlConverter;
import org.sonar.iac.common.yaml.YamlParser;
import org.sonar.iac.common.yaml.YamlSensor;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

public class CloudformationSensor
extends YamlSensor {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final AnalysisWarnings analysisWarnings;

    public CloudformationSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, CloudformationLanguage language, AnalysisWarnings analysisWarnings) {
        super(sonarRuntime, fileLinesContextFactory, checkFactory, noSonarFilter, (Language)language, CloudformationCheckList.checks());
        this.analysisWarnings = analysisWarnings;
    }

    protected TreeParser<Tree> treeParser() {
        return new YamlParser((YamlConverter)new CloudformationConverter());
    }

    protected FilePredicate customFilePredicate(SensorContext sensorContext) {
        return new FileIdentificationPredicate(sensorContext.config().get("sonar.cloudformation.file.identifier").orElse(""));
    }

    protected String repositoryKey() {
        return "cloudformation";
    }

    protected void importExternalReports(SensorContext sensorContext) {
        ExternalReportProvider.getReportFiles((SensorContext)sensorContext, (String)"sonar.cloudformation.cfn-lint.reportPaths").forEach(report -> CfnLintImporter.importReport(sensorContext, report, this.analysisWarnings));
    }

    protected String getActivationSettingKey() {
        return "sonar.cloudformation.activate";
    }

    private static class FileIdentificationPredicate
    implements FilePredicate {
        private static final Logger LOG = Loggers.get(FileIdentificationPredicate.class);
        private static final Pattern LINE_TERMINATOR = Pattern.compile("[\\n\\r\\u2028\\u2029]");
        private final String fileIdentifier;

        public FileIdentificationPredicate(String fileIdentifier) {
            this.fileIdentifier = fileIdentifier;
        }

        public boolean apply(InputFile inputFile) {
            return this.hasFileIdentifier(inputFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasFileIdentifier(InputFile inputFile) {
            if ("".equals(this.fileIdentifier)) {
                return true;
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputFile.inputStream());){
                String[] lines;
                byte[] bytes = bufferedInputStream.readNBytes(8192);
                String text = new String(bytes, inputFile.charset());
                String[] stringArray = lines = LINE_TERMINATOR.split(text);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.contains(this.fileIdentifier)) {
                        boolean bl = true;
                        return bl;
                    }
                    ++n2;
                }
                return false;
            }
            catch (IOException e) {
                LOG.error(String.format("Unable to read file: %s.", inputFile.uri()));
                LOG.error(e.getMessage());
            }
            return false;
        }
    }
}

