/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.cloudformation.checks.utils.XPathUtils;
import org.sonar.iac.cloudformation.tree.FunctionCallTree;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.common.yaml.tree.FileTree;
import org.sonar.iac.common.yaml.tree.MappingTree;
import org.sonar.iac.common.yaml.tree.ScalarTree;
import org.sonar.iac.common.yaml.tree.TupleTree;
import org.sonar.iac.common.yaml.tree.YamlTree;

@Rule(key="S6294")
public class LogGroupDeclarationCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure missing \"Log Groups\" declaration is intended here.";
    private static final Set<String> RELEVANT_RESOURCE = new HashSet<String>(Arrays.asList("AWS::Lambda::Function", "AWS::Serverless::Function", "AWS::ApiGatewayV2::Api", "AWS::CodeBuild::Project"));

    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> {
            List<AbstractResourceCheck.Resource> resources = AbstractResourceCheck.getFileResources(tree);
            Set referencedResourceIdentifier = resources.stream().filter(resource -> resource.isType("AWS::Logs::LogGroup")).filter(resource -> resource.properties() instanceof MappingTree).map(LogGroupDeclarationCheck::getReferenceIdentifiers).flatMap(Collection::stream).collect(Collectors.toSet());
            resources.stream().filter(LogGroupDeclarationCheck::isRelevantResource).filter(r -> !LogGroupDeclarationCheck.matchResourceIdentifier(referencedResourceIdentifier, r)).forEach(resource -> ctx.reportIssue((HasTextRange)resource.type(), MESSAGE));
        });
    }

    private static Set<String> getReferenceIdentifiers(AbstractResourceCheck.Resource logGroupResource) {
        return PropertyUtils.value((Tree)logGroupResource.properties(), (String)"LogGroupName", YamlTree.class).map(LogGroupDeclarationCheck::resolveIdentifiersFromProperty).orElse(Collections.emptySet());
    }

    private static Set<String> resolveIdentifiersFromProperty(YamlTree property) {
        if (property.metadata().tag().endsWith("str")) {
            String value = ((ScalarTree)property).value();
            return Collections.singleton(value.substring(value.lastIndexOf("/") + 1));
        }
        return FunctionReferenceCollector.get(property);
    }

    private static boolean matchResourceIdentifier(Set<String> identifiers, AbstractResourceCheck.Resource resource) {
        return identifiers.contains(resource.name().value()) || identifiers.contains(LogGroupDeclarationCheck.functionName(resource).orElse(null));
    }

    private static Optional<String> functionName(AbstractResourceCheck.Resource resource) {
        return PropertyUtils.value((Tree)resource.properties(), (String)"FunctionName").filter(ScalarTree.class::isInstance).map(s -> ((ScalarTree)s).value());
    }

    private static boolean isRelevantResource(AbstractResourceCheck.Resource resource) {
        return RELEVANT_RESOURCE.contains(TextUtils.getValue((Tree)resource.type()).orElse(null)) && !LogGroupDeclarationCheck.hasLogEvent(resource);
    }

    private static boolean hasLogEvent(AbstractResourceCheck.Resource resource) {
        return PropertyUtils.value((Tree)resource.properties(), (String)"Events").filter(MappingTree.class::isInstance).map(e -> ((MappingTree)e).elements()).orElse(Collections.emptyList()).stream().map(TupleTree::value).anyMatch(e -> XPathUtils.getSingleTree(e, "/Properties/LogGroupName").isPresent());
    }

    static class FunctionReferenceCollector
    extends TreeVisitor<TreeContext> {
        private static final Pattern SUB_PARAMETERS = Pattern.compile("\\$\\{([a-zA-Z0-9.]+)}|([a-zA-Z0-9.]+)");
        private final Set<String> references = new HashSet<String>();

        public FunctionReferenceCollector() {
            this.register(FunctionCallTree.class, (ctx, tree) -> tree.arguments().stream().limit(1L).filter(ScalarTree.class::isInstance).forEach(argument -> this.collectReference(tree.name(), (ScalarTree)argument)));
        }

        private void collectReference(String functionName, ScalarTree argument) {
            if ("Sub".equals(functionName)) {
                this.collectSubParameters(argument);
            } else if ("Ref".equals(functionName)) {
                this.collectRefParameter(argument);
            }
        }

        private void collectSubParameters(ScalarTree subArgument) {
            Matcher m = SUB_PARAMETERS.matcher(subArgument.value());
            while (m.find()) {
                if (m.group(1) != null) {
                    this.references.add(m.group(1));
                    continue;
                }
                this.references.add(m.group(2));
            }
        }

        private void collectRefParameter(ScalarTree ref) {
            this.references.add(ref.value());
        }

        public static Set<String> get(YamlTree logGroupNameProperty) {
            FunctionReferenceCollector collector = new FunctionReferenceCollector();
            collector.scan(new TreeContext(), (Tree)logGroupNameProperty);
            return collector.references;
        }
    }
}

