/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6303")
public class DisabledRDSEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted RDS DB Instances is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"StorageEncrypted\" disables databases encryption. Make sure it is safe here.";
    private static final String SECONDARY_MESSAGE = "Related RDS DBInstance";
    private static final List<String> EXCLUDE_AURORA_ATTRIBUTE = List.of("aurora", "aurora-mysql", "aurora-postgresql");

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (!resource.isType("AWS::RDS::DBInstance")) {
            return;
        }
        if (PropertyUtils.get((Tree)resource.properties(), (String)"Engine").stream().anyMatch(engine -> TextUtils.matchesValue((Tree)engine.value(), EXCLUDE_AURORA_ATTRIBUTE::contains).isTrue())) {
            return;
        }
        PropertyUtils.get((Tree)resource.properties(), (String)"StorageEncrypted").ifPresentOrElse(encryption -> {
            if (TextUtils.isValueFalse((Tree)encryption.value())) {
                ctx.reportIssue((HasTextRange)encryption.key(), MESSAGE, new SecondaryLocation((HasTextRange)resource.type(), SECONDARY_MESSAGE));
            }
        }, () -> ctx.reportIssue((HasTextRange)resource.type(), OMITTING_MESSAGE));
    }
}

