/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.layout;

import java.awt.Component;
import java.awt.Rectangle;
import org.softsmithy.lib.swing.customizer.layout.AbstractTableConstraints;
import org.softsmithy.lib.swing.customizer.layout.TableLayout;

public class RelativeTableConstraints
extends AbstractTableConstraints {
    private int column;
    private int row;
    private int colSpan;
    private int rowSpan;

    public RelativeTableConstraints(Component component, TableLayout tl) {
        this(0, 0, 1, 1, component, tl);
    }

    public RelativeTableConstraints(int column, int row, int colSpan, int rowSpan, Component component, TableLayout tl) {
        this(new Rectangle(column, row, colSpan, rowSpan), component, tl);
    }

    public RelativeTableConstraints(Rectangle bounds, Component component, TableLayout tl) {
        super(component, tl);
        this.setRelativeBounds(bounds);
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    public int getHeight() {
        return this.getTableLayout().height(this.getRow(), this.getRowSpan());
    }

    @Override
    public int getWidth() {
        return this.getTableLayout().width(this.getColumn(), this.getColSpan());
    }

    @Override
    public int getX() {
        return this.getTableLayout().xLocation(this.getColumn());
    }

    @Override
    public int getY() {
        return this.getTableLayout().yLocation(this.getRow());
    }

    @Override
    protected void setAbsoluteBoundsOnly(Rectangle bounds) {
        this.setColumnOnly(this.getTableLayout().columnIndex(bounds.x));
        this.setRowOnly(this.getTableLayout().rowIndex(bounds.y));
        this.setColSpanOnly(this.getTableLayout().colSpan(this.column, bounds.width));
        this.setRowSpanOnly(this.getTableLayout().rowSpan(this.row, bounds.height));
    }

    public void setColSpan(int colSpan) {
        this.setColSpanOnly(colSpan);
        this.updateTableLayout();
    }

    private void setColSpanOnly(int colSpan) {
        this.colSpan = colSpan >= 1 ? colSpan : 1;
    }

    public void setColumn(int column) {
        this.setColumnOnly(column);
        this.updateTableLayout();
    }

    private void setColumnOnly(int column) {
        this.column = column;
    }

    public void setRow(int row) {
        this.setRowOnly(row);
        this.updateTableLayout();
    }

    private void setRowOnly(int row) {
        this.row = row;
    }

    public void setRowSpan(int rowSpan) {
        this.setRowSpanOnly(rowSpan);
        this.updateTableLayout();
    }

    private void setRowSpanOnly(int rowSpan) {
        this.rowSpan = rowSpan >= 1 ? rowSpan : 1;
    }

    @Override
    public Rectangle getAbsoluteBounds() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public Rectangle getRelativeBounds() {
        return new Rectangle(this.column, this.row, this.colSpan, this.rowSpan);
    }

    @Override
    protected void setRelativeBoundsOnly(Rectangle bounds) {
        this.setColumnOnly(bounds.x);
        this.setRowOnly(bounds.y);
        this.setColSpanOnly(bounds.width);
        this.setRowSpanOnly(bounds.height);
    }
}

